package com.huigou.topsun.sap.costCenter.controller;

import com.huigou.topsun.sap.costCenter.application.CostCenterApplication;
import com.huigou.topsun.sap.costCenter.domain.CostCenter;
import com.huigou.topsun.sap.costCenter.domain.query.CostCenterQueryRequest;
import com.huigou.topsun.sap.costCenter.domain.vo.CostCenterVo;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.List;

/**
 * @Auther: xin.lu
 * @Date: 2023/12/13/11:36
 * @Description:
 */
@Controller
@ControllerMapping("/sapCostCenter")
public class CostCenterController extends CommonController {

    @Autowired
    private CostCenterApplication costCenterApplication;

    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/costCenter/";
    }


    /**
     * 跳转到成本中心查询列表
     *
     * @return
     */
    public String forwardSapCostCenterList() {
        return forward("sapCostCenterList");
    }

    public String slicedCostCenterList() {
        SDO sdo = this.getSDO();
        CostCenterQueryRequest costCenterQueryRequest = sdo.toQueryRequest(CostCenterQueryRequest.class);

        return toResult(costCenterApplication.getCostCenterList(costCenterQueryRequest));
    }

    /**
     * 跳转到新增页面
     */
    public String addCostCenterDetail() {
        return forward("sapCostCenterDetail");
    }

    /**
     * 根据id获取成本中心信息
     *
     * @return
     */
    public String showCostCenterDetail() {
        SDO sdo = this.getSDO();
        String id = sdo.getString("id");
        CostCenterVo costCenterVo = costCenterApplication.findCostCenterById(id);
        return forward("sapCostCenterDetail", costCenterVo);

    }

    /**
     * 根据id删除成本中心
     *
     * @return
     */
    public String deleteCostCenterById() {
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();

        costCenterApplication.deleteCostCenterById(ids);
        return success();

    }

    /**
     * 保存/修改 成本中心
     *
     * @return
     */
    public String saveCostCenter() {
        SDO sdo = this.getSDO();
        CostCenterVo costCenterVo = sdo.toObject(CostCenterVo.class);
        CostCenter costCenter = CostCenterVo.getCostCenter(costCenterVo);
//        if (StringUtil.isNotBlank(costCenter.getId()))
//            costCenterApplication.updateCostCenter(costCenter);
//        else
//            costCenterApplication.saveCostCenter(costCenter);
//        return "";
        costCenterVo = costCenterApplication.saveAndUpdate(costCenter);

        return success(costCenterVo);
    }
}
