package com.huigou.topsun.resource.controller;


import com.huigou.cache.DictUtil;
import com.huigou.topsun.resource.service.ResourceTypeService;
import com.huigou.topsun.resource.vo.ResourceFiledVo;
import com.huigou.topsun.resource.vo.ResourceTypeTreeVo;
import com.huigou.topsun.resource.vo.ResourceTypeVo;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2023/10/25/16:34
 * @Description:
 */
//@Tag(name = "资源库")
@Controller
@ControllerMapping("/resource")
public class ResourceController extends CommonController {
    protected String getPagePath() {
        return "/biz/topsun/resource/";
    }
    @Resource
    private ResourceTypeService resourceTypeService;

    /**
     * 资源列表页
     * @return
     */
    public String forwardResourceList(){
        Map<String, String> resourceFieldType = DictUtil.getDictionary("resourceFieldType");
        this.putAttribute("resourceFieldType",resourceFieldType);
        Map<String, String> yesorno = DictUtil.getDictionary("yesorno");
        this.putAttribute("yesorno",yesorno);
        return forward("resourceList");
    }

    /**
     * 添加资源页面
     * @return
     */
    public String forwardFieldTreeDetail(){
        SDO sdo = this.getSDO();
        String tableName = sdo.getString("tableName");
        ResourceTypeVo resourceTypeVo = resourceTypeService.initResourceTypeVo(tableName);
        return forward("fieldTreeDetail",resourceTypeVo);
    }

    /**
     * 修改资源页面
     * @return
     */
    public String forwardUpdateFieldTreeDetail(){
        SDO sdo = this.getSDO();
        String tableName = sdo.getString("tableName");
        ResourceTypeVo resourceTypeVo = resourceTypeService.findByTableName(tableName);
        return forward("fieldTreeDetail",resourceTypeVo);
    }

    //@Operation(summary = "保存资源类型")
    public String saveResourceType(){
        SDO sdo = this.getSDO();
        ResourceTypeVo resourceTypeVo = sdo.toObject(ResourceTypeVo.class);
        List<ResourceFiledVo> resourceFields = sdo.getList("resourceFields", ResourceFiledVo.class);
        resourceTypeVo.setResourceFileds(resourceFields);
        resourceTypeService.saveResourceTypeMain(resourceTypeVo);
        return toResult(resourceTypeVo);
    }

    //@Operation(summary = "修改资源类型")
    public String updateResourceType(){
        SDO sdo = this.getSDO();
        ResourceTypeVo resourceTypeVo = sdo.toObject(ResourceTypeVo.class);
        List<ResourceFiledVo> resourceFields = sdo.getList("resourceFields", ResourceFiledVo.class);
        resourceTypeVo.setResourceFileds(resourceFields);
        resourceTypeService.updateResourceTypeMain(resourceTypeVo);
        return toResult(resourceTypeVo);
    }

    //@Operation(summary = "根据id删除资源")
    public String deleteResourceType(){
        SDO sdo = this.getSDO();
        String tableName = sdo.getString("tableName");
        ResourceTypeVo resourceTypeVo = resourceTypeService.findByTableName(tableName);
        resourceTypeService.deleteById(resourceTypeVo.getResourceTypeId());
        return success();
    }

    //@Operation(summary = "根据id查询资源")
    public String findById(){
        SDO sdo = this.getSDO();
        String id = sdo.getString("id");
        ResourceTypeVo resourceTypeVo = resourceTypeService.findById(id);
        return toResult(resourceTypeVo);
    }

    //@Operation(summary = "查询全部资源")
    public String findList(){
        return toResult(resourceTypeService.findList());
    }

    public String findResourceTypes(){
        SDO sdo = this.getSDO();
        String parentTableName = sdo.getString("parentId");
        List<ResourceTypeTreeVo> resourceTypeTreeVoList = resourceTypeService.queryResourceTypes(parentTableName);
        HashMap<Object, Object> hashMap = new HashMap<>();
        hashMap.put("Rows",resourceTypeTreeVoList);
        return toResult(hashMap);
    }

    /*@Operation(summary = "根据表名，递归查询该表及父类字段")
    @GetMapping("/findParentResourceFields")
    public Result<Set<ResourceFiled>> findParentResourceFields(@RequestParam String tableName){
        return Result.ok(resourceTypeService.findParentResourceFileds(tableName));
    }*/

    //@Operation(summary = "修改/查看资源类型时，根据当前表名，返回自己和父类和超类及所属的字段")
    public String findResourceTypeFields(){
        SDO sdo = this.getSDO();
        String tableName = sdo.getString("tableName");
        return packGridDataAndResult(resourceTypeService.findResourceTypeFields(tableName));
    }

}
