package com.huigou.topsun.product.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;

import javax.persistence.*;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;
import org.apache.commons.lang3.builder.ToStringBuilder;

/**
 * @author Tison
 * 产品风险描述
 */
@Entity
@Table(name = "product_risk_description")
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProductRiskDescription implements Serializable {

	/**
	 * 产品风险描述id
	 */
	@Id
	@Column(name = "product_risk_description_id", nullable = false, length = 32)
	@JsonSerialize(using = NumberToStringSerializer.class)
	private BigDecimal productRiskDescriptionId;

	/**
	 * 产品id
	 */
	@Column(name = "product_id", nullable = true, length = 32)
	@JsonSerialize(using = NumberToStringSerializer.class)
	private BigDecimal productId;

	/**
	 * 序号
	 */
	@Column(name = "sequence", nullable = true)
	private Integer sequence;

	/**
	 * 内容
	 */
	@Column(name = "product_risk_description", nullable = true, length = 255)
	private String productRiskDescription;

	/**
	 * 等级
	 */
	@Column(name = "product_risk_level", nullable = true, length = 32)
	private String productRiskLevel;

	@Override
	public boolean equals(Object o) {
		if (this == o) { return true; }
		if (o == null || getClass() != o.getClass()) { return false; }
		ProductRiskDescription that = (ProductRiskDescription) o;
		return Objects.equals(productRiskDescriptionId, that.productRiskDescriptionId) && Objects.equals(productId, that.productId) && Objects.equals(sequence, that.sequence) && Objects.equals(productRiskDescription, that.productRiskDescription) && Objects.equals(productRiskLevel, that.productRiskLevel);
	}

	@Override
	public int hashCode() {
		return Objects.hash(productRiskDescriptionId, productId, sequence, productRiskDescription, productRiskLevel);
	}

	@Override
	public String toString() {
		return new ToStringBuilder(this)
				.toString();
	}

	public BigDecimal getProductRiskDescriptionId() {
		return productRiskDescriptionId;
	}

	public void setProductRiskDescriptionId(String productRiskDescriptionId) {
		this.productRiskDescriptionId = (productRiskDescriptionId != null) ? new BigDecimal(productRiskDescriptionId) : null;
	}

	public BigDecimal getProductId() {
		return productId;
	}

	public void setProductId(String productId) {
		this.productId = (productId != null) ? new BigDecimal(productId) : null;
	}

	public Integer getSequence() {
		return this.sequence;
	}
	
	public void setSequence(Integer sequence) {
		this.sequence = sequence;
	}
	
	public String getProductRiskDescription() {
		return this.productRiskDescription;
	}
	
	public void setProductRiskDescription(String productRiskDescription) {
		this.productRiskDescription = productRiskDescription;
	}
	
	public String getProductRiskLevel() {
		return this.productRiskLevel;
	}
	
	public void setProductRiskLevel(String productRiskLevel) {
		this.productRiskLevel = productRiskLevel;
	}
}
