package com.huigou.topsun.product.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.*;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;
import lombok.Data;

/**
 * 品牌
 * @TableName brand
 */
@Table(name="brand")
@Entity
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Brand implements Serializable {
    /**
     * 品牌ID
     */
    @Id
    @Column(name = "brand_id")
    @JsonSerialize(using = NumberToStringSerializer.class)
    private BigDecimal brandId;

    /**
     * 品牌名称
     */
    @Column(name = "brand_name")
    private String brandName;

    /**
     * 品牌编码
     */
    @Column(name = "brand_code")
    private String brandCode;

    /**
     * 品牌备注
     */
    @Column(name = "brand_remark")
    private String brandRemark;

    public BigDecimal getBrandId() {
        return brandId;
    }

    public void setBrandId(String brandId) {
        this.brandId = (brandId != null) ? new BigDecimal(brandId) : null;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }

    public String getBrandCode() {
        return brandCode;
    }

    public void setBrandCode(String brandCode) {
        this.brandCode = brandCode;
    }

    public String getBrandRemark() {
        return brandRemark;
    }

    public void setBrandRemark(String brandRemark) {
        this.brandRemark = brandRemark;
    }
}