package com.huigou.topsun.customer.domain;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.*;

import lombok.Data;

/**
 * 客户付款信息
 * @TableName customer_pay_info
 */
@Table(name="customer_pay_info")
@Data
@Entity
public class CustomerPayInfo implements Serializable {
    /**
     * 客户付款信息表id
     */
    @Id
    @Column(name = "customer_pay_info_id")
    private String customerPayInfoId;

    /**
     * 客户id
     */
    @Column(name = "customer_id")
    private String customerId;

    /**
     * 支付方户名
     */
    @Column(name = "customer_pay_account_name")
    private String customerPayAccountName;

    /**
     * 录入人
     */
    @Column(name = "created_by_name")
    private String createdByName;

    /**
     * 录入人id
     */
    @Column(name = "created_by_id")
    private String createdById;

    /**
     * 录入时间
     */
    @Column(name = "created_date")
    private Date createdDate;

    /**
     * 修改人id
     */
    @Column(name = "last_modified_by_id")
    private String lastModifiedById;

    /**
     * 修改人
     */
    @Column(name = "last_modified_by_name")
    private String lastModifiedByName;

    /**
     * 修改日期
     */
    @Column(name = "last_modified_date")
    private Date lastModifiedDate;

    private static final long serialVersionUID = 1L;
}