package com.huigou.topsun.customer.application.Impl;

import com.huigou.topsun.customer.application.CustomerBaseInfoApplication;
import com.huigou.topsun.customer.domain.Customer;
import com.huigou.topsun.customer.domain.CustomerBank;
import com.huigou.topsun.customer.domain.CustomerContact;
import com.huigou.topsun.customer.domain.Province;
import com.huigou.topsun.customer.domain.vo.CustomerVo;
import com.huigou.topsun.customer.repository.CustomerBankRepository;
import com.huigou.topsun.customer.repository.CustomerContactRepository;
import com.huigou.topsun.customer.repository.CustomerRepository;
import com.huigou.topsun.customer.repository.ProvinceRepository;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class CustomerBaseInfoApplicationImpl implements CustomerBaseInfoApplication {
    @Autowired
    private ProvinceRepository provinceRepository;
    @Autowired
    private CustomerRepository customerRepository;
    @Autowired
    private CustomerBankRepository customerBankRepository;
    @Autowired
    private CustomerContactRepository customerContactRepository;


    @Override
    public List<Province> findByProvinceCode(String provinceCode) {
        Province province = provinceRepository.findByProvinceCode(provinceCode);
        List<Province> provinceList = new ArrayList<>();

        if (province != null) {
            String provinceParentId = province.getProvinceParentId();
            //获取上一级信息
            Province parentProvince = provinceRepository.findByProvinceCode(provinceParentId);
            if (parentProvince != null && !provinceParentId.equals(0)) {
                //获取上一级信息
                Province grandParentProvince = provinceRepository.findByProvinceCode(parentProvince.getProvinceParentId());
                if (grandParentProvince != null) {
                    provinceList.add(grandParentProvince);
                }
                provinceList.add(parentProvince);
            }
        }
        provinceList.add(province);
        return provinceList;
    }

    @Override
    public CustomerVo findCustomerByCustomerId(String customerId) {


        Customer customer = customerRepository.findCustomerByCustomerId(customerId);
        String provinceCode = customer.getProvinceCode();
        List<Province> provinceList = findByProvinceCode(provinceCode);
        StringBuffer provinceInfoList = new StringBuffer();
        for (Province province : provinceList) {
            provinceInfoList.append(province.getProvinceName());
        }
        String provinceInfo = provinceInfoList.toString();
        CustomerVo customerVo = new CustomerVo();
        BeanUtils.copyProperties(customer, customerVo);
        customerVo.setProvinceInfo(provinceInfo);
        return customerVo;
    }

    @Override
    public CustomerBank findCustomerBankByCustomerId(String customerId) {
        CustomerBank customerBank = customerBankRepository.findCustomerBankByCustomerId(customerId);
        return customerBank;
    }

    @Override
    public List<CustomerContact> findCustomerContactByCustomerId(String customerId) {
        List<CustomerContact> customerContactList = customerContactRepository.findCustomerContactByCustomerId(customerId);
        return customerContactList;

    }

//    /**
//     * @param provinceCode
//     * @return provinceList
//     */
//    @Override
//    public Province findByProvinceParentId(String provinceCode) {
//
//        Province province = provinceRepository.findByProvinceParentId(provinceCode);
//        return province;
//    }


}
