var gridManager = null;

$(document).ready(function() {
    initializateUI();
    loadCodeRuleListGrid();
});
function initializateUI() {
    //UICtrl.layout("#layout", {leftWidth: 3});
    UICtrl.layout("#layout",{leftWidth: 50});
}

function loadCodeRuleListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function(){
            addHandler();
        },
        updateHandler: function(){
            updateHandler();
        }
    });
    gridManager =  UICtrl.grid("#productListGrid", {
        columns: [
            { display: "产品名称", name: "productName", width: 140, minWidth: 60, type: "string", align: "left", editor: {
                    type: 'text',
                    required: true
                }},
            { display: "产品类别", name: "productCategoryId", width: 120, minWidth: 60, type: "string", align: "left" },
            { display: "产品状态", name: "productStatus", width: 120, minWidth: 60, type: "string", align: "left" },
            { display: "产品计量单位", name: "productUnit", width: 100, minWidth: 60, type: "string", align: "left" },
            { display: "样品编号", name: "productSampleCode", width: 150, minWidth: 60, type: "string", align: "left" },
            { display: "品牌名称", name: "brandName", width: 100, minWidth: 60, type: "string", align: "left" },
            { display: "产品类型", name: "prodcutType", width: 140, minWidth: 60, type: "datetime", align: "left" }
        ],
        dataType: "server",
        url: web_app.name + '/product/findProduct.ajax',
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        enabledEdit: true,
        width: "50%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow : function(data, rowindex, rowobj) {
            updateHandler(data);
        }
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

// parms: {
//     page: 0,
//         size: 30
// },

function updateHandler(data) {
    var id = data.productId;
    if (!id) {
        id = DataUtil.getUpdateRowId(gridManager);
        if (!id) {
            return;
        }
    }
    var url=DataUtil.composeURLByParam('/product/forwardProductDetail.do',{ data: JSON.stringify(data) });
    UICtrl.addTabItem({tabid:'viewFlowChart' + id, text:"产品信息",url:url});
}

function addHandler() {
    let data = {};
    data.productId = 0;
    var url=DataUtil.composeURLByParam('/product/forwardProductDetail.do',{ data: JSON.stringify(data) });
    UICtrl.addTabItem({tabid:'viewFlowChart' + new Date().getTime(), text:"新增产品",url:url});
}



