var gridManager=null;
$(document).ready(function () {
    initializateUI();
    loadContactListGrid();
    //bindQueryEvent();
    bindEvent();
});

function initializateUI() {
    UICtrl.layout("#layout", {leftWidth: 3});
}


function loadContactListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function () {
            addHandler();
        },
        updateHandler: function () {
            updateHandler();
        },
        deleteHandler: function () {
            updateHandler();
        }
    });
    gridManager = UICtrl.grid("#contactListGrid", {
        columns: [
            {
                display: "联系人名称", name: "contactName", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "select",
                    data: {
                        type: 'system',
                        name: "customerContactList",
                        back: {
                            customerContactId: "customerContactId",
                            customerId: "customerId",
                            contactName: "contactName",
                            contactPhone: "contactPhone",
                            contactFax: "contactFax",
                            contactMail: "contactMail"
                        }
                    },
                }
            },
            {display: "联系人电话", name: "contactPhone", width: 300, minWidth: 60, type: "string", align: "left"},
            {display: "传真", name: "contactFax", width: 300, minWidth: 60, type: "number", align: "left"},
            {display: "邮箱", name: "contactMail", width: 300, minWidth: 60, type: "string", align: "left"}
        ],
        dataAction: "server",
        url: web_app.name + '/customer/slicedContactList.ajax',
        parms:{customerId:$("#customerId").val()},
        pageSize: 10,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            updateHandler(data);
        }
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

