﻿var gridManager = null;

$(document).ready(function() {
	initializateUI();
	loadOrgTreeView();
	loadCodeRuleListGrid();
});


function initializateUI() {
	UICtrl.layout("#layout", {leftWidth: 3});  
}


function loadCodeRuleListGrid() {
	var toolbarOptions = UICtrl.getDefaultToolbarOptions({
		updateHandler: function(){
			updateHandler();
		},
		getPurchaseCode:{id:'getPurchaseCode',text:'测试采购编号',img:'fa-link',click:function(){
			testGetNextCode('purchase');
		}},
		getContractCode:{id:'getContractCode',text:'测试合同编号',img:'fa-link',click:function(){
			testGetNextCode('contract');
		}}
	});
    gridManager =  UICtrl.grid("#codeRuleListGrid", {
        columns: [
                  { display: "所属组织", name: "orgName", width: 140, minWidth: 60, type: "string", align: "left" },		   
                  { display: "组织编码", name: "orgCode", width: 120, minWidth: 60, type: "string", align: "left" },
                  { display: "类型", name: "name", width: 120, minWidth: 60, type: "string", align: "left" },	
                  { display: "前缀", name: "prefix", width: 100, minWidth: 60, type: "string", align: "left" },	
                  { display: "编码规则", name: "rule", width: 150, minWidth: 60, type: "string", align: "left" },		   
                  { display: "当前值", name: "currentValue", width: 100, minWidth: 60, type: "string", align: "left" },
                  { display: "最后更新日期", name: "lastModifiedDate", width: 140, minWidth: 60, type: "datetime", align: "left" }						  	
        ],
        dataAction: "server",
     	url: web_app.name + '/codeRule/slicedQueryCodeRule.ajax',
     	pageSize: 20,
     	usePager: true,
     	toolbar: toolbarOptions,
     	width: "100%",
     	height: "100%",
     	heightDiff: -8,
     	checkbox: true,
     	fixedCellHeight: true,
     	selectRowButtonOnly: true,
     	onDblClickRow : function(data, rowindex, rowobj) {
			updateHandler(data.id);
		}
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function loadOrgTreeView() {
	//ssrfOrgRootId hxPurchaseCommon.js
	$('#orgTree').commonTree({
		loadTreesAction:'org/queryOrgs.ajax',
		parentId :ssrfOrgRootId,
		getParam : function(e){
			return {showDisabledOrg:0,displayableOrgKinds : "ogn,dpt"};
		},
		changeNodeIcon:function(data){
			data[this.options.iconFieldName]= OpmUtil.getOrgImgUrl(data.orgKindId, data.status);
		},
		IsShowMenu:false,
		onClick :onFolderTreeNodeClick
	});
}

function onFolderTreeNodeClick(data) {
	var html=[];
	html.push('<span class="tomato-color">[',data.name,']</span>','编号规则管理');
	$('#layout').layout('setCenterTitle',html.join(''));
	$('#treefullId').val(data.fullId);
	if (gridManager) {
		UICtrl.gridSearch(gridManager,{fullId:data.fullId});
	}
}

function query(obj) {
	var param = $(obj).formToJSON();
	UICtrl.gridSearch(gridManager, param);
}

function reloadGrid() {
	gridManager.loadData();
} 

function resetForm(obj) {
	$(obj).formClean();
}

function updateHandler(id){
	if(!id){
		var id = DataUtil.getUpdateRowId(gridManager);
		if (!id){ return; }
	}
	UICtrl.showAjaxDialog({
		url: web_app.name + '/codeRule/showLoadCodeRule.load',
		title: "修改单据编号规则",
		width: 340, 
		param:{id:id}, 
		ok: function(div){
			var _self=this;
			$('#submitForm',div).ajaxSubmit({url: web_app.name + '/codeRule/updateCodeRule.ajax',
				success : function() {
					_self.close();
					reloadGrid();
				}
			});
		}
	});
}

function testGetNextCode(kind){
	var orgId=$('#orgTree').commonTree('getSelectedId');
	if(!orgId){
		Public.tip('请选择组织节点!');
		return false;
	}
	Public.ajax(web_app.name + "/codeRule/testGetNextCode.ajax",{orgId:orgId,ruleKind:kind},function(data){
		UICtrl.alert('成功获取编号:'+data,function(){
			reloadGrid();
		});
	});
}
