package com.huigou.topsun.resource.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.huigou.topsun.resource.domain.ResourceFiled;
import com.huigou.topsun.resource.vo.ResourceFiledVo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
* @author 16508
* @description 针对表【resource_filed(资源字段设置)】的数据库操作Service
* @createDate 2023-10-25 16:08:43
*/
public interface ResourceFiledService extends IService<ResourceFiled> {

    ResourceFiledVo saveResourceFiled(ResourceFiledVo resourceFiledVo);

    void createTable(List<ResourceFiledVo> resourceFileds, String tableName, String tableTile);

    void updateTableAddColumn(List<ResourceFiledVo> resourceFileds, String tableName);

    void updateTableChangeColumn(List<ResourceFiledVo> resourceFileds, String tableName);

    StringBuffer matchFieldType(ResourceFiledVo resourceFiledVo, StringBuffer sql);

    ResourceFiledVo updateResourceFiled(ResourceFiledVo resourceFiled);

    void deleteById(String id);

    void deleteByResourceTypeId(String resourceFieldId);

    ResourceFiledVo findById(String id);

    List<ResourceFiledVo> findList();

    List<ResourceFiledVo> findByResourceTypeId(String resourceTypeId);

    int saveResourceFiledValue(Map<String, Object> map);

    List<Map<String, Object>> getResourceFieldValueList(String resourceTypeId);

    List<Map<String, Object>> getResourceFieldValueListByProcess(String processType);

    int deleteResourceFieldValue(String resourceTypeId, String id);

    List<ResourceFiledVo> findFieldValueByResourceTypeIdAndId(String resourceTypeId, String id);

    void dropTableByResourceName(String tableName);
}
