package com.huigou.topsun.proofing.domain.workInstruction.model;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

/**
 * 作业指导书基本信息
 * @TableName work_instruction_base_info
 */
@Table(name="work_instruction_base_info")
@Entity
@Data
public class WorkInstructionBaseInfo implements Serializable {
    /**
     * 作业指导书id
     */
    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )
    @Column(name = "work_instruction_base_info_id")
    private String workInstructionBaseInfoId;

    /**
     * 产品编码
     */
    @Column(name = "product_id")
    private String productId;

    /**
     * 产品名称
     */
    @Column(name = "product_name")
    private String productName;

    /**
     * 产品类别
     */
    @Column(name = "product_type")
    private String productType;

    /**
     * 产品单位
     */
    @Column(name = "product_unit")
    private String productUnit;

    /**
     * 尺码组id
     */
    @Column(name = "size_group_id")
    private String sizeGroupId;

    /**
     * 是否为唯一码产品
     */
    @Column(name = "is_only_code")
    private String isOnlyCode;

    /**
     * 是否不考虑形体配色
     */
    @Column(name = "is_body_color")
    private String isBodyColor;

    /**
     * 是否禁用
     */
    @Column(name = "is_disable")
    private String isDisable;

    /**
     * 是否创建新规格书
     */
    @Column(name = "is_new_specification")
    private String isNewSpecification;

    /**
     * 是否建立bom表
     */
    @Column(name = "is_build_bom")
    private String isBuildBom;

    /**
     * 确认日期
     */
    @Column(name = "confirm_date")
    private Date confirmDate;

    /**
     * 确认人
     */
    @Column(name = "comfirm_person")
    private String comfirmPerson;

    /**
     * 是否免检
     */
    @Column(name = "is_free_inspection")
    private String isFreeInspection;

    /**
     * 不要质量loss%
     */
    @Column(name = "is_no_quality_loss")
    private String isNoQualityLoss;

    /**
     * 样品单号
     */
    @Column(name = "sample_order_no")
    private String sampleOrderNo;

    /**
     * 库存编码
     */
    @Column(name = "stock_no")
    private String stockNo;

    /**
     * 库存名称
     */
    @Column(name = "stock_name")
    private String stockName;

    /**
     * 存档编号
     */
    @Column(name = "file_no")
    private String fileNo;

    /**
     * 品牌
     */
    private String brand;

    private static final long serialVersionUID = 1L;
}