package com.huigou.topsun.proofing.domain.proofingApply.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 
 * @TableName proofing_apply_process_material
 */
@Table(name="proofing_apply_process_material")
@Entity
@Data
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProofingApplyProcessMaterial implements Serializable {
    /**
     * 打样申请工艺物料ID
     */
    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )
    @Column(name = "proofing_apply_process_material_id")
    private String proofingApplyProcessMaterialId;

    @Column(name = "proofing_apply_technology_id")
    private String proofingApplyTechnologyId ;

    /**
     * 工序ID
     */
    @Column(name = "proofing_apply_process_id")
    private String proofingApplyProcessId;

    /**
     * 物料ID
     */
    @Column(name = "material_id")
    private String materialId;

    /**
     * 物料名称
     */
    @Column(name = "material_name")
    private String materialName;

    /**
     * 使用的物料数量
     */
    @Column(name = "material_number")
    private Double materialNumber;

    /**
     * 物料计量单位
     */
    @Column(name = "material_unit")
    private String materialUnit;

    /**
     * sap物料相信内容
     */
    @Column(name = "material_json")
    private String materialJson;

    private static final long serialVersionUID = 1L;
}