package com.huigou.topsun.proofing.controller;


import com.fasterxml.jackson.core.JsonProcessingException;
import com.huigou.topsun.product.application.ProductLookedApplication;
import com.huigou.topsun.proofing.application.ProofingApplyApplication;
import com.huigou.topsun.proofing.application.ProofingMakeApplication;

import com.huigou.topsun.proofing.domain.proofingMake.model.ProofingMakeBaseInfo;
import com.huigou.topsun.proofing.domain.proofingMake.query.ProofingMakeQueryRequest;
import com.huigou.topsun.proofing.domain.vo.ProofingApplyAndLookedVo;
import com.huigou.topsun.proofing.domain.vo.ProofingMakeVo;


import com.huigou.uasp.annotation.ControllerMapping;

import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.List;
import java.util.Map;
import java.util.UUID;

@Controller
@ControllerMapping("/proofingMake")
public class ProofingMakeController extends CommonController {
    protected String getPagePath() {
        return "/biz/topsun/proofing/";
    }
    @Autowired
    ProofingMakeApplication proofingMakeApplication;
    @Autowired
    ProofingApplyApplication proofingApplyApplication;
    @Autowired
    ProductLookedApplication productLookedApplication;




    /**
     * 跳转打样制造查询页
     * @return
     */
    public String forwardProofingMakeList(){
        return forward("proofingMakeList");
    }


    /**
     * 打样制作表单页
     * @return
     */
    public String forwardProofingMake(){
        String proofingMakeNo = UUID.randomUUID().toString().replace("-", "");
        this.putAttribute("proofingMakeNo", proofingMakeNo);
        this.putAttribute("bizId", "proofingMake"+proofingMakeNo);
        return forward("proofingMake");
    }

    /**
     * 分页查询打样制造表
     * @return
     */
    public String slicedQueryProofingList() {
        SDO sdo = this.getSDO();
        ProofingMakeQueryRequest queryRequest = sdo.toQueryRequest(ProofingMakeQueryRequest.class);
        Map<String, Object> map = proofingMakeApplication.slicedProofingMakeQuery(queryRequest);
        return toResult(map);
    }

    /**
     *  跳转打样制造详情页
     */
    public String forwardDetailsProofingMake(){
        SDO sdo = this.getSDO();
        String id = sdo.getId();
        this.putAttribute("isDetailPage","true");
        ProofingMakeVo proofingMakeVo =(id==null||"".equals(id))?null:proofingMakeApplication.getProofingMakeVoById(id);

        this.putAttribute("bizId", "proofingMake"+proofingMakeVo.getProofingMakeNo());
        Map<String,Object> map=null;
        try {
            map=proofingMakeApplication.mappingReplacementMap(proofingMakeVo);
        } catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return forward("proofingMake",map);
    }

    /**
     * 编辑打样制造信息
     * @return
     */
    public String saveProofingMake(){
        SDO sdo = this.getSDO();
        Map<String, Object> map = proofingMakeApplication.saveProofingMake(sdo);
        return toResult(map);
    }



    /**
     * 根据单号回显相关数据
     * @return
     */
    public String queryProofingApply(){
        SDO sdo = this.getSDO();
        String proofingApplyNo = sdo.getString("proofingApplyNo");
        ProofingApplyAndLookedVo proofingApplyAndLookedVo = proofingApplyApplication.getProofingApplyByProofingApplyNo(proofingApplyNo);
        return toResult(proofingApplyAndLookedVo);
    }



    public String deleteProofingMake(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        proofingMakeApplication.deleteProofingMakeByIds(ids);
        return success();
    }

}
