package com.huigou.topsun.proofing.application.impl;

import com.huigou.cache.DictUtil;
import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.proofing.application.WorkInstructionApplyApplication;
import com.huigou.topsun.proofing.domain.workInstructionApply.model.WorkInstructionApply;
import com.huigou.topsun.proofing.domain.workInstructionApply.query.WorkInstructionApplyQueryRequest;
import com.huigou.topsun.proofing.repository.WorkInstructionApplyRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

@Service
public class WorkInstructionApplyApplicationImpl extends BaseApplication implements WorkInstructionApplyApplication {

    @Autowired
    WorkInstructionApplyRepository workInstructionApplyRepository;

    @Override
    public void saveWorkInstructionApply(WorkInstructionApply workInstructionApply) {
        workInstructionApplyRepository.save(workInstructionApply);
    }

    @Override
    public Map<String, Object> slicedWorkInstructionApplyList(WorkInstructionApplyQueryRequest query) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "slicedWorkInstructionApplyList");
        QueryModel model = this.sqlExecutorDao.getQueryModel(queryDescriptor, query);
        model.putDictionary("isDisable", DictUtil.getDictionary("yesorno"));
        return this.sqlExecutorDao.executeSlicedQuery(model);
    }

    @Override
    public WorkInstructionApply getWorkInstructionApplyById(String workInstructionApplyId) {
        return workInstructionApplyRepository.findOne(workInstructionApplyId);
    }

    @Override
    @Transactional(propagation = Propagation.REQUIRES_NEW)
    public void deleteWorkInstructionById(String id) {
//        workInstructionApplyRepository.delete(id);
        WorkInstructionApply workInstructionApply = workInstructionApplyRepository.findOne(id);
        workInstructionApply.setIsDelete("1");
        workInstructionApplyRepository.save(workInstructionApply);
    }

    @Override
    @Transactional
    public void deleteWorkInstructionByIds(List<String> ids) {
        ids.forEach(this::deleteWorkInstructionById);
    }
}

