package com.huigou.topsun.product.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.*;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;
import lombok.Data;

/**
 * 产品排版配置ID
 * @TableName product_typeset_conf
 */
@Table(name="product_typeset_conf")
@Entity
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProductTypesetConf implements Serializable {
    /**
     * 产品排版配置ID
     */
    @Id
    @Column(name = "product_typeset_conf_id")
    @JsonSerialize(using = NumberToStringSerializer.class)
    private BigDecimal productTypesetConfId;

    /**
     * 产品ID
     */
    @Column(name = "product_id")
    @JsonSerialize(using = NumberToStringSerializer.class)
    private BigDecimal productId;

    /**
     * 印张长度(单位cm)
     */
    private Double length;

    /**
     * 印张宽度(单位cm)
     */
    private Double width;

    /**
     * 满排个数
     */
    private Integer number;

    /**
     * 损耗百分比(单位%)
     */
    @Column(name = "loss_rate")
    private Double lossRate;

    public BigDecimal getProductTypesetConfId() {
        return productTypesetConfId;
    }

    public void setProductTypesetConfId(String productTypesetConfId) {
        this.productTypesetConfId = (productTypesetConfId != null) ? new BigDecimal(productTypesetConfId) : null;
    }

    public BigDecimal getProductId() {
        return productId;
    }

    public void setProductId(String productId) {
        this.productId = (productId != null) ? new BigDecimal(productId) : null;
    }

    public Double getLength() {
        return length;
    }

    public void setLength(Double length) {
        this.length = length;
    }

    public Double getWidth() {
        return width;
    }

    public void setWidth(Double width) {
        this.width = width;
    }

    public Integer getNumber() {
        return number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public Double getLossRate() {
        return lossRate;
    }

    public void setLossRate(Double lossRate) {
        this.lossRate = lossRate;
    }
}