package com.huigou.topsun.product.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.*;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;
import lombok.Data;

/**
 * 产品类别
 * @TableName product_category
 */
@Table(name="product_category")
@Entity
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
public class ProductCategory implements Serializable {
    /**
     * 产品类别ID
     */
    @Id
    @Column(name = "product_category_id")
    @JsonSerialize(using = NumberToStringSerializer.class)
    private BigDecimal productCategoryId;

    /**
     * 产品类别名称
     */
    @Column(name = "product_category_name")
    private String productCategoryName;

    /**
     * 产品类别状态(product_category_status)
     */
    @Column(name = "product_category_status")
    private String productCategoryStatus;

    /**
     * 产品编码
     */
    @Column(name = "product_category_code")
    private String productCategoryCode;

    public BigDecimal getProductCategoryId() {
        return productCategoryId;
    }

    public void setProductCategoryId(String productCategoryId) {
        this.productCategoryId = (productCategoryId != null) ? new BigDecimal(productCategoryId) : null;
    }

    public String getProductCategoryName() {
        return productCategoryName;
    }

    public void setProductCategoryName(String productCategoryName) {
        this.productCategoryName = productCategoryName;
    }

    public String getProductCategoryStatus() {
        return productCategoryStatus;
    }

    public void setProductCategoryStatus(String productCategoryStatus) {
        this.productCategoryStatus = productCategoryStatus;
    }

    public String getProductCategoryCode() {
        return productCategoryCode;
    }

    public void setProductCategoryCode(String productCategoryCode) {
        this.productCategoryCode = productCategoryCode;
    }
}