package com.huigou.topsun.product.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.*;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;
import lombok.Data;

/**
 * 颜色
 * @TableName color
 */
@Table(name="color")
@Entity
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Color implements Serializable {
    /**
     * 颜色ID
     */
    @Id
    @Column(name = "color_id")
    @JsonSerialize(using = NumberToStringSerializer.class)
    private BigDecimal colorId;

    /**
     * 颜色名称
     */
    @Column(name = "color_name")
    private String colorName;

    /**
     * 颜色编码
     */
    @Column(name = "color_code")
    private String colorCode;

    /**
     * 备注
     */
    @Column(name = "color_remark")
    private String colorRemark;

    public BigDecimal getColorId() {
        return colorId;
    }

    public void setColorId(String colorId) {
        this.colorId = (colorId != null) ? new BigDecimal(colorId) : null;
    }

    public String getColorName() {
        return colorName;
    }

    public void setColorName(String colorName) {
        this.colorName = colorName;
    }

    public String getColorCode() {
        return colorCode;
    }

    public void setColorCode(String colorCode) {
        this.colorCode = colorCode;
    }

    public String getColorRemark() {
        return colorRemark;
    }

    public void setColorRemark(String colorRemark) {
        this.colorRemark = colorRemark;
    }
}