package com.huigou.topsun.product.controller;

import com.huigou.cache.DictUtil;
import com.huigou.topsun.product.application.SizeGroupApplication;
import com.huigou.topsun.product.domain.query.SizeGroupQueryRequest;
import com.huigou.topsun.product.domain.vo.SizeGroupItemVo;
import com.huigou.topsun.product.domain.vo.SizeGroupVo;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.List;
import java.util.Map;

/**
 * title: 尺码组相关业务
 * author:ZHT
 * date:2023/12/8
 * description:
 */
@Controller
@ControllerMapping("/sizeGroup")
public class SizeGroupController extends CommonController {

    @Autowired
    private SizeGroupApplication sizeGroupApplication;

    @Override
    protected String getPagePath() {
        return "/biz/topsun/product/";
    }

    /**
     * 跳转到尺码组页面
     */
    public String forwardSizeGroupList() {
        Map<String, String> processType = DictUtil.getDictionary("processType");
        this.putAttribute("processType", processType);
        return forward("sizeGroup");
    }
    /**
     * 跳转到尺码组添加/修改/明细页面
     */
    public String addSizeGroupDetail(){
        return forward("sizeGroupDetail");
    }

    /**
     * 获取尺码组列表(分页)
     */
    public String findSizeGroupList() {

        SDO sdo = this.getSDO();
        SizeGroupQueryRequest sizeGroupQueryRequest = sdo.toQueryRequest(SizeGroupQueryRequest.class);

        return toResult(sizeGroupApplication.getSizeGroupList(sizeGroupQueryRequest));
    }

    /**
     * 添加新的尺码组信息
     */
    public String saveSizeGroup() {
        SDO sdo = this.getSDO();
        SizeGroupVo sizeGroupVo = sdo.toObject(SizeGroupVo.class);
        List<SizeGroupItemVo> sizeGroupItemList = sdo.getList("sizeGroupItemList", SizeGroupItemVo.class);
        // 获取操作人信息
        String personMemberId = sdo.getOperator().getPersonMemberId();
        String personMemberName = sdo.getOperator().getPersonMemberName();
        if (StringUtil.isNotBlank(sizeGroupVo.getSizeGroupId())) {
            // 封装修改人信息
            sizeGroupVo.setLastModifiedById(personMemberId);
            sizeGroupVo.setLastModifiedByName(personMemberName);
            // 修改尺码组信息和尺码信息
            sizeGroupApplication.updateSizeGroup(sizeGroupVo, sizeGroupItemList);
        } else {
            // 封装创建人信息
            sizeGroupVo.setCreatedById(personMemberId);
            sizeGroupVo.setCreatedByName(personMemberName);
            sizeGroupVo = sizeGroupApplication.saveSizeGroup(sizeGroupVo, sizeGroupItemList);
        }
        return success(sizeGroupVo);
    }

    /**
     * 编辑选中的尺码组信息
     */
//    public String updateSizeGroup() {
//               return "";
//    }

    /**
     * 删除选中的尺码组
     */
    public String deleteSizeGroupById() {
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        sizeGroupApplication.deleteSizeGroup(ids);
        return success();
    }

    /**
     * 根据尺码组id获取尺码列表
     */
    public String findSizeGroupItemByGroupId() {
        return "";
    }

    /**
     * 添加尺码
     */
    public String saveSizeGroupItem() {
        return "";
    }

    /**
     * 修改尺码
     */
    public String updateSizeGroupItem() {
        return "";
    }

    /**
     * 删除尺码
     */
    public String deleteSizeGroupItemById() {

        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();

        sizeGroupApplication.deleteSizeGroupItemById(ids);
        return success();
    }

    /**
     * 查看尺码组明细
     */
    public String showSizeGroupDetail() {
        SDO sdo = this.getSDO();
        String sizeGroupId = sdo.getString("sizeGroupId");
//        this.putAttribute("productName", "1");
        SizeGroupVo sizeGroupVo = sizeGroupApplication.findSIzeGroupBySizeGroupId(sizeGroupId);
        return forward("sizeGroupDetail", sizeGroupVo);
    }

    public String slicedSizeGroupItemList(){
        SDO sdo = this.getSDO();
        String sizeGroupId = sdo.getString("sizeGroupId");
        return packGridDataAndResult(sizeGroupApplication.findBySizeGroupId(sizeGroupId));
    }
}
