<%@ page contentType="text/html; charset=utf-8" language="java" %>
<%@ taglib uri="/WEB-INF/taglib.tld" prefix="x" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<html>
<head>
    <x:base include="date,layout,grid,combox,tree,comboDialog,attachment"/>
</head>
<body>
<div class="container-fluid">
    <div class="blank_div"></div>
    <div id="leave-grid"></div>
</div>
<script>
    $(function () {
        let gridManager;
        const toolbarOptions = UICtrl.getDefaultToolbarOptions({
            printHandler: {
                id: 'print', text: '打印', img: 'fa-clipboard', click: function () {
                }
            }, procModifyHandler: {
                id: 'procModify', text: '变更', img: 'fa-clipboard', click: function () {
                    const row = DataUtil.getUpdateRow(gridManager);
                    if (!row) {
                        return;
                    }
                    Public.locationHref('leave/showInsertLeave.job', {id: row.id});
                }
            }
        });
        const columns = [];

        columns.push({display: '编号', name: "billCode", minWidth: 60, type: "string", align: "left"});
        columns.push({display: '请假人', name: "personMemberName", minWidth: 60, type: "string", align: "left"});
        columns.push({display: '填表时间', name: "fillinDate", minWidth: 60, type: "string", align: "left"});
        columns.push({display: '请假天数', name: "days", minWidth: 60, type: "string", align: "left"});
        gridManager = UICtrl.grid('#leave-grid', {
            columns: columns,
            dataAction: 'server',
            url: web_app.name + '/leave/slicedQueryMyLeave.ajax',
            checkbox: true,
            width: '100%',
            height: '100%',
            heightDiff: -5,
            sortName: 'fillinDate',
            sortOrder: 'desc',
            toolbar: toolbarOptions,
            onDblClickRow: function (data, rowindex, rowobj) {
                // viewHandler(data);
            }
        });
    });
</script>
</body>
</html>