var gridManager = null;

$(document).ready(function () {
    initializateUI();
    loadCustomerInfoListGrid();
});

function initializateUI() {
    UICtrl.layout("#layout", {leftWidth: 3});
}

function loadCustomerInfoListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function () {
            addHandler();
        },
        updateHandler: function () {
            updateHandler();
        },
        deleteHandler: function () {
            updateHandler();
        }
    });
    gridManager = UICtrl.grid("#customerInfoListGrid", {
        columns: [
            {display: "客户编码", name: "customerCode", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "客户名称", name: "customerShortName", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "客户英文名称", name: "customerEnName", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "客户英文名称简称", name: "customerEnShortName", width: 160, minWidth: 60, type: "string", align: "left"},
            {display: "客户工作时间", name: "customerWorkTime", width: 120, minWidth: 60, type: "datetime", align: "left"},
            {display: "客户等级", name: "customerLevel", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "工厂代号", name: "customerFactoryCode", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "地址", name: "customerAddress", width: 160, minWidth: 60, type: "string", align: "left"},
            {display: "所属集团", name: "customerGroup", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "邮编", name: "customerZipCode", width: 120, minWidth: 60, type: "string", align: "left"},
        ],
        dataAction: "server",
        url: web_app.name + '/customer/findCustomer.ajax',
        pageSize: 20,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            updateHandler(data);
        }
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}

function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}

//增加按钮
function addHandler() {
    UICtrl.addTabItem({
        tabid: 'addCustomerDetail',
        text: '添加客户详细信息',
        url: web_app.name + '/customer/addCustomerDetail.do'
    })
}

//删除按钮
function deleteHandler() {
    DataUtil.del({
        action: 'customer/deleteCustomer.ajax',
        gridManager: gridManager, idFieldName: 'customerId',
        onSuccess: function () {
            reloadGrid();
        }
    });
}

//修改按钮
function updateHandler(data) {
    if (!data) {
        data = DataUtil.getUpdateRow(gridManager);
        if(!data) {
            return;
        }
    }
    UICtrl.addTabItem({
        tabid: 'customerDetail' + data.customerId,
        text: '客户详细信息',
        url: web_app.name + '/customer/forwardCustomerDetail.do?customerId=' + data.customerId
    })
}

/**
 * 刷新表格
 */
function reloadGrid(obj) {
    sizeGroupGridManager.loadData();
}


