<%@ page contentType="text/html; charset=utf-8"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="/WEB-INF/taglib.tld" prefix="x"%>
<!DOCTYPE html>
<html>
<head>
<x:base include="dialog,dateTime,tree,combox,echart" />
<x:script src='/system/taskCenter/TasksExecute.js'/>
<x:script src='/system/bpm/BpmUtil.js'/>
<x:script src='/javaScript/remind.js'/>
<x:script src='/javaScript/addFunction.js'/>
<x:script src='/javaScript/HomePage.js'/>
<x:script src='/javaScript/HomePageEcharts.js'/>
</head>
<body>
	<div class="container-gray-bg" >
		 <div class="row-fluid m-t-sm">
         	<div class="col-xs-12">
	            <div class="alert alert-block alert-info m-b-xs">
	            	<div class="main-function-box">
						<div class="main-function-left" id="mainFunctionBox"></div>
						<div class="main-function-right">
							<button type="button" class="btn btn-info btn-lg" id="mainAddFunction"><i class="fa fa-plus"></i></button>
						</div>		
					</div>		
				</div>
	        </div>
         </div>
         
         <div class="row-fluid m-t-sm col-padding-sm p-l-xs p-r-xs">
         	 <div class="col-sm-6 col-xs-12">
	            <div class="box box-danger">
		            <div class="box-header with-border">
		              <h3 class="box-title">待办任务</h3>
		              <div class="box-tools pull-right">
		                <button type="button" class="btn btn-box-tool" title="刷新" onclick="reloadGrid()"><i class="fa fa-repeat"></i></button>
		                <button type="button" class="btn btn-box-tool" title="更多" onclick="waitTaskMore()"><i class="fa fa-bars"></i></button>
		              </div>
		            </div>
		            <div class="box-body">
		            	<c:import url="/system/taskCenter/TasksWait.jsp"/>
		            </div>
	          	</div>
	        </div>
	        <div class="col-sm-6 col-xs-12">
	            <div class="box box-success">
		            <div class="box-header with-border">
		              <h3 class="box-title">跟踪任务</h3>
		              <div class="box-tools pull-right">
		                <button type="button" class="btn btn-box-tool" title="刷新" onclick="reloadGrid()"><i class="fa fa-repeat"></i></button>
		                <button type="button" class="btn btn-box-tool" title="更多" onclick="trackTaskMore()"><i class="fa fa-bars"></i></button>
		              </div>
		            </div>
		            <div class="box-body">
		            	<c:import url="/system/taskCenter/TasksTracking.jsp"/>
		            </div>
	          	</div>
	        </div>

			 <div class="row-fluid m-t-sm col-padding-sm p-l-xs p-r-xs">
				 <div class="col-sm-6 col-xs-12">
					 <div class="box box-warning">
						 <div class="box-header with-border">
							 <h3 class="box-title"><x:message key="index.task.center.done"/></h3>
							 <div class="box-tools pull-right">
								 <button type="button" class="btn btn-box-tool" title="刷新" onclick="reloadGrid()"><i class="fa fa-repeat"></i></button>
								 <button type="button" class="btn btn-box-tool" title="更多" onclick="showTasksMore(2)"><i
										 class="fa fa-bars"></i></button>
							 </div>
						 </div>
						 <div class="box-body">
							 <div class="data-list-warp" id="taskDoneContent">
							 </div>
						 </div>
					 </div>
				 </div>
				 <div class="col-sm-6 col-xs-12">
					 <div class="box box-primary">
						 <div class="box-header with-border">
							 <h3 class="box-title"><x:message key="index.task.center.procdone"/></h3>
							 <div class="box-tools pull-right">
								 <button type="button" class="btn btn-box-tool" title="刷新" onclick="reloadGrid()"><i class="fa fa-repeat"></i></button>
								 <button type="button" class="btn btn-box-tool" title="更多" onclick="showTasksMore(8)"><i
										 class="fa fa-bars"></i></button>
							 </div>
						 </div>
						 <div class="box-body">
							 <div class="data-list-warp" id="procdoneContent"></div>
						 </div>
					 </div>
				 </div>
			 </div>
         </div>
	</div>
</body>
</html>