package com.huigou.topsun.technology.application.impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.topsun.technology.application.ProcessResourceApplication;
import com.huigou.topsun.technology.domain.model.ProcessResource;
import com.huigou.topsun.technology.repository.ProcessResourceRepository;
import com.huigou.topsun.technology.vo.ProcessResourceVo;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
* @author 16508
* @description 针对表【process_resource(工序资源)】的数据库操作Service实现
* @createDate 2023-11-22 11:04:03
*/
@Service
public class ProcessResourceApplicationImpl extends BaseApplication implements ProcessResourceApplication {
    @Resource
    private ProcessResourceRepository processResourceRepository;

    @Override
    public ProcessResource saveProcessResource(ProcessResource processResource) {
        return processResourceRepository.saveAndFlush(processResource);
    }

    @Override
    public void deleteByTechnologyProcessId(String technologyProcessId) {
        List<ProcessResource> processResourceList = processResourceRepository.findByProcessId(technologyProcessId);
        processResourceRepository.delete(processResourceList);
    }

    @Override
    public void deleteByIds(List<String> ids) {
        ids.forEach(id->{
            processResourceRepository.delete(id);
        });
    }

    @Override
    public void saveProcessResource(String processId, List<ProcessResource> resourceList) {
        resourceList
                .forEach(processResource -> {
                    processResource.setProcessId(processId);
                    processResourceRepository.save(processResource);
                });
    }

    @Override
    public List<ProcessResourceVo> slicedProcessResourceList(String processId) {
        QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "slicedProcessResourceList");
        return this.sqlExecutorDao.queryToList(queryDescriptor.getSql(),ProcessResourceVo.class,processId);
    }
}




