package com.huigou.topsun.sap.common.serializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.huigou.topsun.sap.common.domain.Message;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component("messageCodec")
public class MessageCodec implements MessageSerializer, MessageDeserializer {

    @Override
    public String serialize(Map<String, Object> map) {
        return JSON.toJSONString(map, SerializerFeature.DisableCircularReferenceDetect);
    }

    @Override
    public Message deserialze(String text) {
        JSONObject jsonObject = JSONObject.parseObject(text);
        Map<String, Object> body = jsonObject.getJSONObject("body");
        Message message = new Message();
        message.getBody().putAll(body);
        return message;
    }


}
