package com.huigou.topsun.product.application;

import com.huigou.topsun.product.domain.query.SizeGroupQueryRequest;
import com.huigou.topsun.product.domain.vo.SizeGroupItemVo;
import com.huigou.topsun.product.domain.vo.SizeGroupVo;

import java.util.List;
import java.util.Map;

/**
 * title: 尺码组相关业务
 * author:ZHT
 * date:2023/12/8
 * description:
 *  关于尺码组相关业务的service实现
 *  表: size_group
 */
public interface SizeGroupApplication {

    public static final String QUERY_XML_FILE_PATH = "config/topsun/product/sizeGroup.xml";
    /**
     * 获取页码组列表
     */
    Map<String,Object> getSizeGroupList(SizeGroupQueryRequest queryRequest);

    SizeGroupVo saveSizeGroup(SizeGroupVo sizeGroupVo, List<SizeGroupItemVo> sizeGroupItemList);

    void updateSizeGroup(SizeGroupVo sizeGroupVo, List<SizeGroupItemVo> sizeGroupItemList);

    SizeGroupVo findSIzeGroupBySizeGroupId(String sizeGroupId);

    void deleteSizeGroup(List<String> ids);

//    Object slicedSizeGroupItemList(String sizeGroupId);

    Object findBySizeGroupId(String sizeGroupId);

    void deleteSizeGroupItemById(List<String> ids);
}
