package com.huigou.topsun.dataSource;

public class HandleDataSource {

    public static final ThreadLocal<String> holder = new ThreadLocal<String>();

    /**
     * 绑定当前线程数据源
     *
     * @param datasource
     */
    public static void putDataSource(String datasource) {
        holder.set(datasource);
    }

    /**
     * 获取当前线程的数据源
     *
     * @return
     */
    public static String getDataSource() {
        return holder.get();
    }

    public static void removeDataSource(){
        holder.remove();
    }

}