package com.huigou.topsun.customer.domain;

import java.io.Serializable;
import javax.persistence.*;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

/**
 * 客户银行信息
 * @TableName customer_bank
 */
@Table(name="customer_bank")
@Data
@Entity
public class CustomerBank implements Serializable {
    /**
     * 
     */
    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "guid")
    @Column(name = "customer_bank_id")
    private String customerBankId;

    /**
     * 客户id
     */
    @Column(name = "customer_id")
    private String customerId;

    /**
     * 开户银行
     */
    @Column(name = "customer_bank_deposit")
    private String customerBankDeposit;

    /**
     * 银行账号
     */
    @Column(name = "customer_account_no")
    private String customerAccountNo;

    /**
     * 户名
     */
    @Column(name = "customer_account_name")
    private String customerAccountName;

    /**
     * 公司法人
     */
    @Column(name = "customer_corporation")
    private String customerCorporation;

    /**
     * 工商注册号
     */
    @Column(name = "business_registration_number")
    private String businessRegistrationNumber;

    /**
     * 国税注册号
     */
    @Column(name = "national_tax_registration_number")
    private String nationalTaxRegistrationNumber;

    private static final long serialVersionUID = 1L;
}