package com.huigou.topsun.customer.application;

import com.huigou.topsun.customer.domain.CustomerContact;
import com.huigou.topsun.customer.domain.CustomerDebtContact;
import com.huigou.topsun.customer.domain.CustomerPayInfo;
import com.huigou.topsun.customer.domain.CustomerRelated;
import com.huigou.topsun.customer.domain.query.ContactQueryRequest;
import com.huigou.topsun.customer.domain.query.CustomerQueryRequest;
import com.huigou.topsun.customer.domain.vo.CustomerVo;

import java.util.List;
import java.util.Map;

/**
 * 分页查询客户信息数据
 */
public interface CustomerApplication {
    Map<String, Object> findCustomerByPage(CustomerQueryRequest customerQueryRequest);

    List<CustomerContact> findContactByPage(String customerId);
    void deleteContactById(String id);

    void deleteContactByIds(List<String> ids);

    CustomerVo saveCustomer(CustomerVo customerVo, List<CustomerContact> customerContactList, List<CustomerDebtContact> baoshenEmailList, List<CustomerDebtContact> customerEmailList, List<CustomerRelated> customerRelatedList, List<CustomerPayInfo> customerPayInfoList);

    void deleteCustomerAndAffiliatedInfoByCustomerId(List<String> customerIds);
}
