var gridManager = null;

$(document).ready(function () {
    initialize();
    loadStatsIndicatorsDetailListGrid();
});
function initialize(){
    let isDetailPage = ($("#isDetailPage").val() === "true");
    if (isDetailPage) {
        $("#jobPageTop").hide();
    }
}

function loadStatsIndicatorsDetailListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function () {
            UICtrl.addGridRow(gridManager,{ zlenr: gridManager.getData().length + 1 });
        },
        deleteHandler: function () {
            var _grid = UICtrl.getGridManager('#statsIndicatorsDetailGrid');
            _grid.deleteSelectedRow();//删除选定节点
        }
    });
    gridManager = UICtrl.grid("#statsIndicatorsDetailGrid", {
        columns: [
            {
                display: "行号", name: "zlenr", width: 140, minWidth: 60, type: "string", align: "left",
                editor: { type: 'spinner', min: 1, max: 100, mask: 'nnn'}
            },
            {
                display: "成本中心", name: "ekostl", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false, type: "select",
                    data: {
                        type: 'system',
                        name: "queryCostCenter",
                        back: {
                            kostl: "ekostl",
                            // ktext:"ekostlTextView",
                            null:"eaufnr"
                        }
                    },
                }
            },
            {
                display: "订单", name: "eaufnr", width: 120, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false, type: "select",
                    data: {
                        type: 'system',
                        name: "sapMaterialSelect",
                        back: {
                             null:"ekostl",
                            materialId:"eaufnr"
                        }
                    },
                }
            },
            {
                display: "统计指标", name: "stagr", width: 120, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true,
                    type: 'dictionary',
                    data: {name:'sex'} ,
                    textField:'stagrTextView',
                    valueField:'sex'
                }
            },
            {
                display: "统计指标数量", name: "mbgbtr", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true,
                    type: 'text',
                    mask: 'nnnn'
                }
            },
            {
                display: "行文本", name: "sgtxt", width: 140, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true,
                    type: 'text'
                }
            }
        ],
        dataAction: "server",
        url: web_app.name + '/sapStatsIndicators/slicedStatsIndicatorsDetailList.ajax',
        pageSize: 10,
        usePager: true,
        parms:{statsIndicatorsId:getId()},
        toolbar: toolbarOptions,
        enabledEdit: true,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            doView(data.statsIndicatorsDetailId);
        }
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

/**
 * 流程引擎回调设置打样的id
 * @param value 打样申请的id
 */
function setId(id) {
    $("#id").val(id);
}

/**
 * 流程引擎获取打样申请id的回掉方法。
 * @return 打样申请的id
 */
function getId() {
    return $("#id").val() || "";
}

function getExtendedData(processAction) {
//回退、打回、转交时，不需要验证必填项是否已经填写；
    if (processAction == ProcessAction.BACK
        || processAction == ProcessAction.REPLENISH
        || processAction == ProcessAction.TRANSMIT) {
//不验证
        $('#submitForm').attr('check', false);
    }
    const isAllData = $('#oldId') || !getId();
    var extendedData = {};
    var _grid = UICtrl.getGridManager('#statsIndicatorsDetailGrid');
    if (_grid) {
        var datas = DataUtil.getGridData({
            gridManager: _grid,
            isAllData: isAllData
        });
        debugger
        if (!datas) {
            return false;
        }else if (datas.some(item => item.ekostl === "" && item.eaufnr === "")){
                const nullItems = datas.filter(item => item.ekostl === "" && item.eaufnr === "").map(item => item.zlenr);
                Public.tip("行号[" + nullItems.join(",") + "]成本中心or订单选择一栏填写");
                return false;
        }

        extendedData.statsIndicatorsDetail = Public.encodeJSONURI(datas);
    }
    return extendedData;
}