﻿var gridManager = null;

$(document).ready(function () {
    initializateUI();
    loadProofingMakeListGrid();
});

function initializateUI() {
    UICtrl.layout("#layout", {leftWidth: 3});
}

function loadProofingMakeListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        updateHandler: function (){
            updateHandler()
        },
        deleteHandler: deleteHandler
    });
    gridManager = UICtrl.grid("#proofingMakeTableGrid", {
        columns: [
            {display: "制造单号", name: "proofingMakeNo", width: 140, minWidth: 60, type: "string", align: "left"},
            {display: "申请单号", name: "proofingApplyNo", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "产品编号", name: "productCode", width: 120, minWidth: 60, type: "string", align: "left"},
            {display: "品牌客户编号", name: "customerCode", width: 140, minWidth: 60, type: "string", align: "left"},
            {
                display: "版面需求时间",
                name: "proofingMakePageNeedTime",
                width: 120,
                minWidth: 60,
                type: "string",
                align: "left"
            },
            {
                display: "完成日期",
                name: "proofingMakeCompleteDate",
                width: 140,
                minWidth: 60,
                type: "string",
                align: "left"
            },
            {
                display: "样品中文名称",
                name: "proofingMakeSampleCnName",
                width: 120,
                minWidth: 60,
                type: "string",
                align: "left"
            },
            {
                display: "样品英文名称",
                name: "proofingMakeSampleEnName",
                width: 140,
                minWidth: 60,
                type: "string",
                align: "left"
            },
            {
                display: "样品版次",
                name: "proofingMakeSampleVersion",
                width: 120,
                minWidth: 60,
                type: "string",
                align: "left"
            },
            {
                display: "样品规格",
                name: "proofingMakeSampleSize",
                width: 140,
                minWidth: 60,
                type: "string",
                align: "left"
            },
            {
                display: "样品数量",
                name: "proofingMakeSampleNum",
                width: 120,
                minWidth: 60,
                type: "string",
                align: "left"
            },
            {
                display: "产量情况",
                name: "proofingMakeOutputSituation",
                width: 140,
                minWidth: 60,
                type: "string",
                align: "left"
            },
            {
                display: "产品代号",
                name: "proofingMakeProductNo",
                width: 140,
                minWidth: 60,
                type: "string",
                align: "left"
            },
            {display: "版面", name: "materialName", width: 140, minWidth: 60, type: "string", align: "left"},
            {
                display: "分配方式",
                name: "proofingApplyAllocationType",
                width: 140,
                minWidth: 60,
                type: "string",
                align: "left"
            },
            // {display: "产品类别", name: "materialName", width: 140, minWidth: 60, type: "string", align: "left"},
            {
                display: "表面处理",
                name: "proofingApplySurfaceTreatment",
                width: 140,
                minWidth: 60,
                type: "string",
                align: "left"
            },
            {
                display: "NG重新打样原因",
                name: "proofingMakeNgReReason",
                width: 120,
                minWidth: 60,
                type: "string",
                align: "left"
            },
            {
                display: "测试标准",
                name: "proofingApplyTestStandard",
                width: 120,
                minWidth: 60,
                type: "string",
                align: "left"
            },
            {
                display: "申请单状态",
                name: "proofingMakeApplicationStatus",
                width: 120,
                minWidth: 60,
                type: "string",
                align: "left"
            }
        //     ,{display: "颜色种类", name: "colorType", width: 120, minWidth: 60, type: "string", align: "left"},
        //     {display: "专", name: "expert", width: 120, minWidth: 60, type: "string", align: "left"},
        //     {display: "网版目数", name: "printingPlateNum", width: 120, minWidth: 60, type: "string", align: "left"},
        //     {display: "啤版目数", name: "beerPlateNum", width: 120, minWidth: 60, type: "string", align: "left"},
        //     {display: "模切板模数", name: "dieBoardNum", width: 120, minWidth: 60, type: "string", align: "left"},
        //     {display: "标准色号", name: "materialNumber", width: 120, minWidth: 60, type: "string", align: "left"},
         ],
        dataAction: "server",
        url: web_app.name + '/proofingMake/slicedQueryProofingList.ajax',
        pageSize: 10,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "100%",
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,
        onDblClickRow: function (data, rowindex, rowobj) {
            doView(data.proofingMakeId);
        }
    });
    UICtrl.setSearchAreaToggle(gridManager);
}

function query(obj) {
    var param = $(obj).formToJSON();
    UICtrl.gridSearch(gridManager, param);
}

function reloadGrid() {
    gridManager.loadData();
}

function resetForm(obj) {
    $(obj).formClean();
}

// function addHandler() {
//     UICtrl.showAjaxDialog({
//         url: web_app.name + '/proofingMake/forwardSaveProofingMake.load',
//         title: "新增打样制造单",
//         width: 1000,
//         ok: function (div) {
//             var _self = this;
//             $('#submitForm', div).ajaxSubmit({
//                 url: web_app.name + '/proofingMake/saveProofingMake.ajax',
//                 success: function () {
//                     _self.close();
//                     reloadGrid();
//                 }
//             });
//         }
//     });
// }

function updateHandler() {

      let  row = DataUtil.getUpdateRow(gridManager);

            UICtrl.addTabItem({
                tabid: 'updateProofingMake'+row.proofingMakeId,
                text: "制造单修改",
                url: web_app.name + '/proofingMake/forwardDetailsProofingMake.do?id='+row.proofingMakeId
            });

}

//重写DataUtil的getUpdateRowId函数、它默认取行的id列
DataUtil.getUpdateRowId = function (gridManager) {
    var result = DataUtil.getUpdateRow(gridManager);
    if (result) {
        return result.proofingMakeId;
    }
    return result;
}

//删除按钮
function deleteHandler() {
    DataUtil.del({
        action: 'proofingMake/deleteProofingMake.ajax',
        gridManager: gridManager, idFieldName: 'proofingMakeId',
        onSuccess: function () {
            reloadGrid();
        }
    });
}

function doView(proofingMakeId) {
    UICtrl.addTabItem({
        tabid: 'showProofingMake'+proofingMakeId,
        text: "制造单详情",
        url: web_app.name + '/proofingMake/forwardDetailsProofingMake.job?id='+proofingMakeId
    });
}