<%@ page contentType="text/html;charset=UTF-8" language="java" %>
<%@taglib uri="/WEB-INF/taglib.tld" prefix="x" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<html>
<head>
    <x:base include="layout,dialog,grid,tree,dateTime,combox,commonTree"/>
    <x:script src='/system/opm/js/OpmUtil.js'/>
    <x:script src='/biz/topsun/common/purchaseCommon.js'/>
    <x:script src='/biz/topsun/customer/customerDetail.js'/>
</head>
<body>
<x:billTitle title="客户信息详情" needStatus="false" needPerson="true"/>
<div class="blank_div clearfix"></div>
<button class="btn btn-default" type="button" id="close" style="left: 200px;float:right;bottom: 10px;">关闭</button>
<button class="btn btn-success" type="button" id="save" style="left: 200px;float:right;bottom: 10px;">保存</button>
<div class="blank_div clearfix"></div>
<form class="hg-form" method="post" action="" id="submitForm">
    <x:hidden name="id"/>
    <x:hidden name="billCode"/>
    <x:hidden name="fillinDate" type="datetime"/>
    <x:hidden name="fullId"/>
    <x:hidden name="organId"/>
    <x:hidden name="organName"/>
    <x:hidden name="deptId"/>
    <x:hidden name="deptName"/>
    <x:hidden name="positionId"/>
    <x:hidden name="positionName"/>
    <x:hidden name="personMemberId"/>
    <x:hidden name="personMemberName"/>

    <div id="customerTab" style="margin: 0px;">
        <div class="ui-tab-links">
            <ul id="customer_ul">
                <li id="customerBaseInfo" divid="customerBaseInfoDiv">客户基本信息</li>
                <li id="customerDebtContact" divid="customerDebtContactDiv">催货款通知邮箱</li>
                <li id="customerOtherInfo" divid="customerOtherInfoDiv">其他信息</li>
            </ul>
        </div>

        <div class="ui-tab-content" style="padding: 2px; padding-right: 0;">
            <div class="layout" id="customerBaseInfoDiv">
                <x:hidden name="customerId"/>
                <x:hidden name="customerBankId"/>
                <x:inputC name="customerCode" label="客户编码" labelCol="1" fieldCol="2"/>
                <x:inputC name="customerName" label="客户全称" labelCol="1" fieldCol="2"/>
                <x:inputC name="customerShortName" label="客户简称" labelCol="1" fieldCol="2"/>
                <x:inputC name="customerWorkTime" label="客户工作时间" wrapper="dateTime" labelCol="1" fieldCol="2"/>
                <x:inputC name="customerEnName" label="英文名称" labelCol="1" fieldCol="2"/>
                <x:inputC name="customerEnShortName" label="英文名简称" labelCol="1" fieldCol="2"/>
                <x:inputC name="provinceInfo" label="所属地区" maxLength="32" labelCol="1" fieldCol="2"
                          readonly="true"/>
                <x:hidden name="provinceCode"></x:hidden>
                <x:selectC name="customerLevel" label="客户等级" dictionary="customerLevel" labelCol="1" fieldCol="2"/>
                <x:inputC name="customerFactoryCode" label="工厂代号" maxLength="32" labelCol="1" fieldCol="2"/>
                <x:inputC name="customerAddress" label="地址" maxLength="32" labelCol="1" fieldCol="2"/>
                <x:inputC name="customerGroup" label="所属集团" maxLength="32" labelCol="1" fieldCol="2"/>
                <x:inputC name="customerZipCode" label="邮编" maxLength="32" labelCol="1" fieldCol="2"/>
                <x:inputC name="customerBankDeposit" label="开户银行" maxLength="32" labelCol="1" fieldCol="2"/>
                <x:inputC name="customerAccountNo" label="银行账户" maxLength="32" labelCol="1" fieldCol="2"/>
                <x:inputC name="customerAccountName" label="户名" maxLength="32" labelCol="1" fieldCol="2"/>
                <x:inputC name="customerCorporation" label="公司法人" maxLength="32" labelCol="1" fieldCol="2"/>
                <x:inputC name="businessRegistrationNumber" label="工商注册号" maxLength="32" labelCol="1"
                          fieldCol="2"/>
                <x:inputC name="nationalTaxRegistrationNumber" label="国税注册号" maxLength="32" labelCol="1"
                          fieldCol="2"/>
                <div id="contact" position="center">
                    <x:title title="联系人列表" name="group"/>
                    <div id="contactListGrid" style="margin: 2px;">
                        <hr>
                    </div>
                </div>
            </div>
            <div class="layout" id="customerDebtContactDiv">
                <div id='emailTab' style="margin: 0px;">
                    <div class="ui-tab-links">
                        <ul id="email_ul">
                            <li id="baoshenEmailListForm" divid="baoshenEmailListDiv">宝绅邮箱</li>
                            <li id="customerEmailListForm" divid="customerEmailListDiv">客户邮箱</li>
                        </ul>
                    </div>
                    <div class="ui-tab-content" style="padding: 2px; padding-right: 0;">
                        <div class="layout" id="baoshenEmailListDiv">
                            <div id="baoshenEmailList" position="center">
                                <x:title title="宝绅邮箱列表" name="group"/>
                                <div id="baoshenEmailListGrid" style="margin: 2px;">
                                    <hr>
                                </div>
                            </div>
                        </div>
                        <div class="layout" id="customerEmailListDiv">
                            <div id="customerEmailList" position="center">
                                <x:title title="客户邮箱列表" name="group"/>
                                <div id="customerEmailListGrid" style="margin: 2px;">
                                    <hr>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>


            </div>
            <div class="layout" id="customerOtherInfoDiv">
                <div id="customerRelated" position="center">
                    <x:title title="客户关联关系信息" name="group"/>
                    <div id="customerRelatedListGrid" style="margin: 2px;">
                        <hr>
                    </div>
                </div>
                <div id="customerPayInfo" position="center">
                    <x:title title="客户付款信息" name="group"/>
                    <div id="customerPayInfoListGrid" style="margin: 2px;">
                        <hr>
                    </div>
                </div>
            </div>

        </div>
    </div>


</form>
</body>
</html>