var contactGridManager = null;
var baoshenEmailGridManager = null;
var customerEmailGridManager = null;
var customerRelatedGridManager = null;
var customerPayInfoGridManager = null;
$(document).ready(function () {
    initializeTab();
    initializeUI();
    loadContactListGrid();
    bindEvent();
    loadBaoshenEmailListGrid();
    loadCustomerEmailListGrid();
    loadCustomerRelatedListGrid();
    loadCustomerPayInfoListGrid();
});


function initializeUI() {
    UICtrl.layout("#layout", {leftWidth: 3});
}

function initializeTab() {
    $('#customerTab').tab();
    $('#emailTab').tab()
}


function loadContactListGrid() {
    //增删改控件
    var toolbarOptions = UICtrl.getDefaultToolbarOptions({
        addHandler: function () {
            addContactHandler();
        },
        deleteHandler: function () {
            deleteContactHandler();
        }
    });
    contactGridManager = UICtrl.grid("#contactListGrid", {
        columns: [
            {
                display: "联系人名称", name: "contactName", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text"
                }
            },
            {
                display: "联系人电话", name: "contactPhone", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text"
                }
            },
            {
                display: "传真", name: "contactFax", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: false, type: "text"
                }
            },
            {
                display: "邮箱", name: "contactMail", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text"
                }
            }
        ],
        dataAction: "server",
        url: web_app.name + '/customer/slicedContactList.ajax',
        parms: {customerId: $("#customerId").val()},
        pageSize: 10,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "40%",
        enabledEdit: true,
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true,

    });
    UICtrl.setSearchAreaToggle(contactGridManager);
}


//添加联系人
function addContactHandler() {
    UICtrl.addGridRow(contactGridManager);
}

//删除联系人
function deleteContactHandler() {
    var _grid = UICtrl.getGridManager('#contactListGrid');
    DataUtil.delSelectedRows(
        {
            action: 'customer/deleteContact.ajax',
            param: {},
            gridManager: _grid,
            idFieldName: 'customerContactId',
            onSuccess: function (data) {
                if (data == "1") {
                    Public.successTip("删除成功！");
                }
                contactGridManager.loadData();
            }
        }
    )
}


function loadBaoshenEmailListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions(
        {
            addHandler: function () {
                UICtrl.addGridRow(baoshenEmailGridManager);
            },
            deleteHandler: function () {
                deleteBaoshenEmailHandler();
                // var _grid = UICtrl.getGridManager('#baoshenEmailListGrid');
                // DataUtil.delSelectedRows(
                //     {
                //         action: 'customerDebtContact/deleteCustomerDebtContact.ajax',
                //         param: {},
                //         gridManager: _grid,
                //         idFieldName: 'customerDebtContactId',
                //         onSuccess: function () {
                //             if (data == "1"){
                //                 Public.successTip("删除成功！");
                //             }
                //             baoshenEmailGridManager.loadData();
                //         }
                //     }
                // )
            }
        }
    );
    baoshenEmailGridManager = UICtrl.grid("#baoshenEmailListGrid", {
        columns: [
            {
                display: "邮箱地址", name: "customerEmail", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text"
                },

            },
            {
                display: "联系人", name: "customerContact", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text"
                },
            },
            {
                display: "是否开启邮件发送", name: "sendEmailTextView", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {

                    type: 'dictionary',
                    data: {
                        name: 'yesorno'
                    },
                    textField: 'sendEmailTextView',
                    valueField: 'sendEmail',
                    required: true

                },
            },
            {
                display: "创建人", name: "createdByName", width: 300, minWidth: 60, type: "string", align: "left",

            }
        ],
        dataAction: "server",
        url: web_app.name + '/customerDebtContact/slicedCustomerDebtContactList.ajax',
        parms: {customerId: $("#customerId").val(), customerEmailType: 0},
        pageSize: 10,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "60%",
        enabledEdit: true,
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true
    });
}

function deleteBaoshenEmailHandler() {
    var _grid = UICtrl.getGridManager('#baoshenEmailListGrid');
    DataUtil.delSelectedRows(
        {
            action: 'customerDebtContact/deleteCustomerDebtContact.ajax',
            param: {},
            gridManager: _grid,
            idFieldName: 'customerDebtContactId',
            onSuccess: function (data) {
                if (data == "1") {
                    Public.successTip("删除成功！");
                }
                baoshenEmailGridManager.loadData();
            }
        }
    )
}

function loadCustomerEmailListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions(
        {
            addHandler: function () {
                UICtrl.addGridRow(customerEmailGridManager);
            },
            deleteHandler: function () {
                deleteCustomerEmailHandler();
                // var _grid = UICtrl.getGridManager('#customerEmailListGrid');
                // DataUtil.delSelectedRows(
                //     {
                //         action: 'customerDebtContact/deleteCustomerDebtContact.ajax',
                //         param: {},
                //         gridManager: _grid,
                //         idFieldName: 'customerDebtContactId',
                //         onSuccess: function () {
                //             if (data == "1"){
                //                 Public.successTip("删除成功！");
                //             }
                //             // customerEmailGridManager.loadData();
                //             loadCustomerEmailListGrid();
                //         }
                //     }
                // )
            }
        }
    );
    customerEmailGridManager = UICtrl.grid("#customerEmailListGrid", {
        columns: [
            {
                display: "邮箱地址", name: "customerEmail", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text",
                }
            },
            {
                display: "联系人", name: "customerContact", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {
                    required: true, type: "text",
                }
            },
            {
                display: "是否开启邮件发送", name: "sendEmailTextView", width: 300, minWidth: 60, type: "string", align: "left",
                editor: {

                    type: 'dictionary',
                    data: {
                        name: 'yesorno'
                    },
                    textField: 'sendEmailTextView',
                    valueField: 'sendEmail',
                    required: true

                },
            },
            {
                display: "创建人", name: "createdByName", width: 300, minWidth: 60, type: "string", align: "left",

            }
        ],
        dataAction: "server",
        url: web_app.name + '/customerDebtContact/slicedCustomerDebtContactList.ajax',
        parms: {customerId: $("#customerId").val(), customerEmailType: 1},
        pageSize: 10,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "60%",
        enabledEdit: true,
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true
    });
}

function deleteCustomerEmailHandler() {
    var _grid = UICtrl.getGridManager('#customerEmailListGrid');
    DataUtil.delSelectedRows(
        {
            action: 'customerDebtContact/deleteCustomerDebtContact.ajax',
            param: {},
            gridManager: _grid,
            idFieldName: 'customerDebtContactId',
            onSuccess: function (data) {
                if (data == "1") {
                    Public.successTip("删除成功！");
                }
                customerEmailGridManager.loadData();
            }
        }
    )
}

function loadCustomerRelatedListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions(
        {
            addHandler: function () {
                UICtrl.addGridRow(customerRelatedGridManager);
            },
            deleteHandler: function () {
                deleteCustomerRelatedHandler();
                // var _grid = UICtrl.getGridManager('#customerRelatedListGrid');
                // DataUtil.delSelectedRows(
                //     {
                //         action: 'customerRelated/deleteCustomerRelated.ajax',
                //         param: {},
                //         gridManager: _grid,
                //         idFieldName: 'customerRelatedId',
                //         onSuccess: function () {
                //             if (data == "1"){
                //                 Public.successTip("删除成功！");
                //             }
                //             // customerRelatedGridManager.loadData();
                //             loadCustomerRelatedListGrid();
                //         }
                //     }
                // )
            }
        }
    );
    customerRelatedGridManager = UICtrl.grid("#customerRelatedListGrid", {
        columns: [
            {
                display: "关联客户编码",
                name: "customerCodeRelated",
                width: 200,
                minWidth: 60,
                type: "string",
                align: "left",
                editor: {
                    required: true, type: "text"
                }
            },
            {
                display: "关联客户简称",
                name: "customerShortNameRelated",
                width: 200,
                minWidth: 60,
                type: "string",
                align: "left",
                editor: {
                    required: true, type: "text"
                }
            },
            {
                display: "关联客户全称",
                name: "customerNameRelated",
                width: 200,
                minWidth: 60,
                type: "string",
                align: "left",
                editor: {
                    required: true, type: "text"
                }
            },
            {
                display: "录入人", name: "createdByName", width: 200, minWidth: 60, type: "string", align: "left",

            },
            {
                display: "录入时间", name: "createdDate", width: 200, minWidth: 60, type: "string", align: "left",

            },

        ],
        dataAction: "server",
        url: web_app.name + '/customerRelated/slicedCustomerRelatedList.ajax',
        parms: {customerId: $("#customerId").val()},
        pageSize: 10,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "40%",
        enabledEdit: true,
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true
    });
}

function deleteCustomerRelatedHandler() {
    var _grid = UICtrl.getGridManager('#customerRelatedListGrid');
    DataUtil.delSelectedRows(
        {
            action: 'customerRelated/deleteCustomerRelated.ajax',
            param: {},
            gridManager: _grid,
            idFieldName: 'customerRelatedId',
            onSuccess: function (data) {
                if (data == "1") {
                    Public.successTip("删除成功！");
                }
                customerRelatedGridManager.loadData();
                // loadCustomerRelatedListGrid();
            }
        }
    )
}

function loadCustomerPayInfoListGrid() {
    var toolbarOptions = UICtrl.getDefaultToolbarOptions(
        {
            addHandler: function () {
                UICtrl.addGridRow(customerPayInfoGridManager);
            },

            deleteHandler: function () {
                deleteCustomerPayInfoHandler();
                // var _grid = UICtrl.getGridManager('#customerPayInfoListGrid');
                // DataUtil.delSelectedRows(
                //     {
                //         action: 'customerPayInfo/deleteCustomerPayInfo.ajax',
                //         param: {},
                //         gridManager: _grid,
                //         idFieldName: 'customerPayInfoId',
                //         onSuccess: function () {
                //             if (data == "1"){
                //                 Public.successTip("删除成功！");
                //             }
                //             // customerPayInfoGridManager.loadData();
                //             loadCustomerPayInfoListGrid();
                //         }
                //     }
                // )
            }
        }
    );
    customerPayInfoGridManager = UICtrl.grid("#customerPayInfoListGrid", {
        columns: [
            {
                display: "支付方户名",
                name: "customerPayAccountName",
                width: 200,
                minWidth: 60,
                type: "string",
                align: "left",
                editor: {
                    required: true, type: "text",
                }
            },
            {
                display: "录入人", name: "createdByName", width: 200, minWidth: 60, type: "string", align: "left",

            },
            {
                display: "录入时间", name: "createdDate", width: 200, minWidth: 60, type: "date", align: "left",

            },
            {
                display: "修改人", name: "lastModifiedByName", width: 200, minWidth: 60, type: "string", align: "left",
            },
            {
                display: "修改时间", name: "lastModifiedDate", width: 200, minWidth: 60, type: "date", align: "left",

            }
        ],
        dataAction: "server",
        url: web_app.name + '/customerPayInfo/slicedCustomerPayInfoList.ajax',
        parms: {customerId: $("#customerId").val()},
        pageSize: 10,
        usePager: true,
        toolbar: toolbarOptions,
        width: "100%",
        height: "40%",
        enabledEdit: true,
        heightDiff: -8,
        checkbox: true,
        fixedCellHeight: true,
        selectRowButtonOnly: true
    });
}

function deleteCustomerPayInfoHandler() {
    var _grid = UICtrl.getGridManager('#customerPayInfoListGrid');
    DataUtil.delSelectedRows(
        {
            action: 'customerPayInfo/deleteCustomerPayInfo.ajax',
            param: {},
            gridManager: _grid,
            idFieldName: 'customerPayInfoId',
            onSuccess: function (data) {
                if (data == "1") {
                    Public.successTip("删除成功！");
                }
                customerPayInfoGridManager.loadData();
            }
        }
    )
}


function bindEvent() {
    $("#save").click(function () {//保存整体保存
        saveData();
    })

    $("#close").click(function () {//关闭
        closeDispatchTabItem();
    })
}

function getCustomerDetail() {
    var contactList = [];
    var baoshenEmailList = [];
    var customerEmailList = [];
    var customerRelatedList = [];
    var customerPayInfoList = [];
    var customerVo = $('#submitForm').formToJSON(true);
    if (!customerVo) {
        return false;
    }
    contactList = DataUtil.getGridData({gridManager: contactGridManager, isAllData: true})
    baoshenEmailList = DataUtil.getGridData({gridManager: baoshenEmailGridManager, isAllData: true})
    customerEmailList = DataUtil.getGridData({gridManager: customerEmailGridManager, isAllData: true})
    customerRelatedList = DataUtil.getGridData({gridManager: customerRelatedGridManager, isAllData: true})
    customerPayInfoList = DataUtil.getGridData({gridManager: customerPayInfoGridManager, isAllData: true})
    customerVo.contactList = $.toJSON(contactList);
    customerVo.baoshenEmailList = $.toJSON(baoshenEmailList);
    customerVo.customerEmailList = $.toJSON(customerEmailList);
    customerVo.customerRelatedList = $.toJSON(customerRelatedList);
    customerVo.customerPayInfoList = $.toJSON(customerPayInfoList);
    return customerVo;

}

//右上角的保存控件
function saveData() {
    var customerDetail = getCustomerDetail();
    if (!customerDetail) {
        return;
    }
    Public.ajax(web_app.name + '/customer/saveCustomer.ajax', customerDetail,
        function (data) {
            Public.successTip("common.tip.success");
            contactGridManager.setParm('customerId', data.customerId);
            contactGridManager.loadData();
            baoshenEmailGridManager.setParm('customerId', data.customerId);
            baoshenEmailGridManager.loadData();
            customerEmailGridManager.setParm('customerId', data.customerId);
            customerEmailGridManager.loadData();
            customerRelatedGridManager.setParm('customerId', data.customerId);
            customerRelatedGridManager.loadData();
            customerPayInfoGridManager.setParm('customerId', data.customerId);
            customerPayInfoGridManager.loadData();
        }
    );
}

function closeDispatchTabItem() {
    UICtrl.closeCurrentTab();
}
