package com.huigou.topsun.technology.domain.model;

import java.io.Serializable;
import javax.persistence.*;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

/**
 * 工艺
 * @TableName technology
 */
@Table(name="technology")
@Data
@Entity
public class Technology implements Serializable {
    /**
     * 工艺路线ID
     */
    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "guid")
    @Column(name = "technology_id")
    private String technologyId;

    /**
     * 工艺路线名称
     */
    @Column(name = "technology_name")
    private String technologyName;

    /**
     * 产品ID
     */
    @Column(name = "product_id")
    private String productId;

    /**
     * 工艺版本
     */
    @Column(name = "technology_version")
    private String technologyVersion;

    /**
     * 工艺类型(technology_type)
     */
    @Column(name = "technology_type")
    private String technologyType;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        Technology other = (Technology) that;
        return (this.getTechnologyId() == null ? other.getTechnologyId() == null : this.getTechnologyId().equals(other.getTechnologyId()))
            && (this.getTechnologyName() == null ? other.getTechnologyName() == null : this.getTechnologyName().equals(other.getTechnologyName()))
            && (this.getProductId() == null ? other.getProductId() == null : this.getProductId().equals(other.getProductId()))
            && (this.getTechnologyVersion() == null ? other.getTechnologyVersion() == null : this.getTechnologyVersion().equals(other.getTechnologyVersion()))
            && (this.getTechnologyType() == null ? other.getTechnologyType() == null : this.getTechnologyType().equals(other.getTechnologyType()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getTechnologyId() == null) ? 0 : getTechnologyId().hashCode());
        result = prime * result + ((getTechnologyName() == null) ? 0 : getTechnologyName().hashCode());
        result = prime * result + ((getProductId() == null) ? 0 : getProductId().hashCode());
        result = prime * result + ((getTechnologyVersion() == null) ? 0 : getTechnologyVersion().hashCode());
        result = prime * result + ((getTechnologyType() == null) ? 0 : getTechnologyType().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", technologyId=").append(technologyId);
        sb.append(", technologyName=").append(technologyName);
        sb.append(", productId=").append(productId);
        sb.append(", technologyVersion=").append(technologyVersion);
        sb.append(", technologyType=").append(technologyType);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}