package com.huigou.topsun.technology.controller;

import com.huigou.topsun.technology.application.TechnologyProcessApplication;
import com.huigou.topsun.technology.domain.query.TechnologyProcessQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.List;

/**
 * @Auther: xin.lu
 * @Date: 2023/11/23/16:56
 * @Description:
 */
@Controller
@ControllerMapping("/technologyProcess")
public class TechnologyProcessController extends CommonController {

    @Resource
    private TechnologyProcessApplication technologyProcessApplication;

    public String slicedTechnologyProcessList(){
        SDO sdo = this.getSDO();
        String technologyId = sdo.getString("technologyId");
        return packGridDataAndResult(technologyProcessApplication.slicedTechnologyProcessList(technologyId));
    }

    public String deleteTechnologyProcess(){
        SDO sdo = this.getSDO();
        List<String> technologyProcessIds = sdo.getIds();
        return success();
    }
}
