package com.huigou.topsun.technology.application;


import com.huigou.topsun.technology.domain.model.ProcessMaterialItem;
import com.huigou.topsun.technology.domain.model.ProcessResource;
import com.huigou.topsun.technology.domain.query.ProcessQueryRequest;
import com.huigou.topsun.technology.vo.ProcessVo;

import java.util.List;
import java.util.Map;

/**
* @author 16508
* @description 针对表【process(工序)】的数据库操作Service
* @createDate 2023-11-22 11:04:03
*/
public interface ProcessApplication {

    public static final String QUERY_XML_FILE_PATH = "config/topsun/technology/process.xml";

    ProcessVo saveProcess(ProcessVo processVo);

    void deleteProcessByProcessId(String processId);

    Map<String,Object> slicedProcessList(ProcessQueryRequest queryRequest);

    ProcessVo findProcessByProcessId(String processId);

    void deleteProcessByProcessIds(List<String> ids);

    ProcessVo saveProcessAndResourceAndMaterial(ProcessVo processVo, List<ProcessResource> resourceList, List<ProcessMaterialItem> processMaterialList);
}
