package com.huigou.topsun.quotation.domain.query;

import com.huigou.data.domain.query.QueryAbstractRequest;
import lombok.Data;

import java.util.Date;

/**
 * 报价单
 * @TableName quotation
 */
@Data
public class QuotationQueryRequest extends QueryAbstractRequest {
    /**
     * 报价单id
     */
    private String quotationId;

    /**
     * 报价单类型（码表quotation_type）
     */
    private String quotationType;

    /**
     * 品牌/工厂客户id
     */
    private Long customerManagerId;

    /**
     * 报价日期
     */
    private Date quotationDate;

    /**
     * 创建人id
     */
    private Long createBy;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改人id
     */
    private Long updateBy;

    /**
     * 修改时间
     */
    private Date updateTime;

    /**
     * 报价单流转状态（码表quotation_status）
     */
    private String quotationStatus;

    /**
     * 注意事项
     */
    private String quotationNote;

    /**
     * 发件人
     */
    private String quotationFrom;

    /**
     * 回复
     */
    private String quotationRe;

    /**
     * 前言
     */
    private String quotationMessage;

    /**
     * 报价单号
     */
    private String quotationNo;

    /**
     * 备注
     */
    private String quotationRemark;

    /**
     * 客户是否签回（码表quotation_sign_back）
     */
    private String customerSignBack;

    /**
     * 主管
     */
    private Long manager;

    /**
     * 经办人
     */
    private Long handler;

    /**
     * 业务员
     */
    private Long salesman;
}