package com.huigou.topsun.quotation.domain.model;

import java.io.Serializable;
import javax.persistence.*;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

/**
 * 客户管理
 * @TableName customer_manager
 */
@Table(name="customer_manager")
@Data
@Entity
public class CustomerManager implements Serializable {
    /**
     * 客户ID
     */
    @Id
    @GeneratedValue(generator = "system-uuid")
    @GenericGenerator(name = "system-uuid", strategy = "guid")
    @Column(name = "customer_manager_id")
    private String customerManagerId;

    /**
     * 客户公司名称
     */
    @Column(name = "customer_name")
    private String customerName;

    /**
     * 客户公司名称英文
     */
    @Column(name = "customer_name_en")
    private String customerNameEn;

    /**
     * 客户公司地址
     */
    private String address;

    /**
     * 电话
     */
    @Column(name = "customer_phone")
    private String customerPhone;

    /**
     * 传真
     */
    @Column(name = "customer_fax")
    private String customerFax;

    /**
     * 邮件
     */
    @Column(name = "customer_email")
    private String customerEmail;

    /**
     * 联系人名称
     */
    @Column(name = "customer_contacts")
    private String customerContacts;

    /**
     * 客户类型（customer_type）
     */
    @Column(name = "customer_type")
    private String customerType;

    private static final long serialVersionUID = 1L;

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null) {
            return false;
        }
        if (getClass() != that.getClass()) {
            return false;
        }
        CustomerManager other = (CustomerManager) that;
        return (this.getCustomerManagerId() == null ? other.getCustomerManagerId() == null : this.getCustomerManagerId().equals(other.getCustomerManagerId()))
            && (this.getCustomerName() == null ? other.getCustomerName() == null : this.getCustomerName().equals(other.getCustomerName()))
            && (this.getCustomerNameEn() == null ? other.getCustomerNameEn() == null : this.getCustomerNameEn().equals(other.getCustomerNameEn()))
            && (this.getAddress() == null ? other.getAddress() == null : this.getAddress().equals(other.getAddress()))
            && (this.getCustomerPhone() == null ? other.getCustomerPhone() == null : this.getCustomerPhone().equals(other.getCustomerPhone()))
            && (this.getCustomerFax() == null ? other.getCustomerFax() == null : this.getCustomerFax().equals(other.getCustomerFax()))
            && (this.getCustomerEmail() == null ? other.getCustomerEmail() == null : this.getCustomerEmail().equals(other.getCustomerEmail()))
            && (this.getCustomerContacts() == null ? other.getCustomerContacts() == null : this.getCustomerContacts().equals(other.getCustomerContacts()))
            && (this.getCustomerType() == null ? other.getCustomerType() == null : this.getCustomerType().equals(other.getCustomerType()));
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((getCustomerManagerId() == null) ? 0 : getCustomerManagerId().hashCode());
        result = prime * result + ((getCustomerName() == null) ? 0 : getCustomerName().hashCode());
        result = prime * result + ((getCustomerNameEn() == null) ? 0 : getCustomerNameEn().hashCode());
        result = prime * result + ((getAddress() == null) ? 0 : getAddress().hashCode());
        result = prime * result + ((getCustomerPhone() == null) ? 0 : getCustomerPhone().hashCode());
        result = prime * result + ((getCustomerFax() == null) ? 0 : getCustomerFax().hashCode());
        result = prime * result + ((getCustomerEmail() == null) ? 0 : getCustomerEmail().hashCode());
        result = prime * result + ((getCustomerContacts() == null) ? 0 : getCustomerContacts().hashCode());
        result = prime * result + ((getCustomerType() == null) ? 0 : getCustomerType().hashCode());
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(getClass().getSimpleName());
        sb.append(" [");
        sb.append("Hash = ").append(hashCode());
        sb.append(", customerManagerId=").append(customerManagerId);
        sb.append(", customerName=").append(customerName);
        sb.append(", customerNameEn=").append(customerNameEn);
        sb.append(", address=").append(address);
        sb.append(", customerPhone=").append(customerPhone);
        sb.append(", customerFax=").append(customerFax);
        sb.append(", customerEmail=").append(customerEmail);
        sb.append(", customerContacts=").append(customerContacts);
        sb.append(", customerType=").append(customerType);
        sb.append(", serialVersionUID=").append(serialVersionUID);
        sb.append("]");
        return sb.toString();
    }
}