package com.huigou.topsun.proofing.domain.proofingApply.model;

import com.topsunit.query.annotations.Dictionary;
import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 打样申请样品外观要求
 * @TableName proofing_apply_looked
 */
@Table(name="proofing_apply_looked")
@Entity
@Data
public class ProofingApplyLooked implements Serializable {
    /**
     * 打样申请样品外观id
     */
    @Id

    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )
    @Column(name = "proofing_apply_looked_id")
    private String proofingApplyLookedId;

    /**
     * 打样申请id
     */
    @Column(name = "proofing_apply_id")
    private String proofingApplyId;

    /**
     * 塑胶袋结构
     */
    @Column(name = "plastic_bag_structure")
    private String plasticBagStructure;

    /**
     * 是否量产
     */
    @Column(name = "is_output")
    private String isOutput;

    /**
     * 是否外发
     */
    @Column(name = "is_out")
    private String isOut;

    /**
     * 是否改变
     */
    @Dictionary("yesorno")
    @Column(name = "is_change")
    private String isChange;

    /**
     * 长;单位cm
     */
    @Column(name = "product_length")
    private Double productLength;

    /**
     * 宽;单位cm
     */
    @Column(name = "product_width")
    private Double productWidth;

    /**
     * 高;单位cm
     */
    @Column(name = "product_height")
    private Double productHeight;

    /**
     * 厚度;单位mm
     */
    @Column(name = "product_thick")
    private Double productThick;

    /**
     * 单层厚(单位丝)
     */
    @Column(name = "product_single_layer")
    private Integer productSingleLayer;

    /**
     * 层数
     */
    @Column(name = "product_layer_num")
    private Integer productLayerNum;

    private static final long serialVersionUID = 1L;
}