package com.huigou.topsun.proofing.controller;

import com.huigou.topsun.product.application.ProductApplication;
import com.huigou.topsun.proofing.application.WorkInstructionApplyApplication;
import com.huigou.topsun.proofing.domain.workInstructionApply.model.WorkInstructionApply;
import com.huigou.topsun.proofing.domain.workInstructionApply.query.WorkInstructionApplyQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

import java.util.List;
import java.util.Map;
import java.util.UUID;


@Controller
@ControllerMapping("/workInstructionApply")
public class WorkInstructionApplyController extends CommonController {

    protected String getPagePath() {
        return "/biz/topsun/proofing/";
    }

    @Autowired
    ProductApplication productApplication;
    @Autowired
    WorkInstructionApplyApplication workInstructionApplyApplication;


    /**
     * 跳转打样制造查询页
     * @return
     */
    public String forwardWorkInstructionApplyList(){
        return forward("workInstructionApplyList");
    }

    /**
     * 跳转作业指导申请书
     * 如果有productId参数，就说明从打样制造单发送的请求，携带该参数跳转
     * @return
     */
    public String forwardWorkInstructionApply(){
        SDO sdo = this.getSDO();
        String productId = sdo.getString("productId");
        String workInstructionApplyId = UUID.randomUUID().toString().replace("-", "");
        this.putAttribute("workInstructionApplyId",workInstructionApplyId);
        if(productId!=null&&!"".equals(productId))this.putAttribute("productId", productId);
        return forward("workInstructionApply");
    }


    /**
     * 添加指导申请书
     */
    public String saveWorkInstructionApply(){
        SDO sdo = this.getSDO();
        WorkInstructionApply workInstructionApply = sdo.toObject(WorkInstructionApply.class);
        workInstructionApplyApplication.saveWorkInstructionApply(workInstructionApply);
        return toResult(workInstructionApply);
    }

    /**
     * 分页查询作业申请书
     * @return
     */
    public String slicedQueryWorkInstructionApplyList(){
        SDO sdo = this.getSDO();
        WorkInstructionApplyQueryRequest workInstructionApplyQueryRequest = sdo.toQueryRequest(WorkInstructionApplyQueryRequest.class);
        Map<String, Object> map = workInstructionApplyApplication.slicedWorkInstructionApplyList(workInstructionApplyQueryRequest);
        return toResult(map);
    }
    /**
     *  跳转作业申请书详情页
     */
    public String forwardDetailsWorkInstructionApply(){
        SDO sdo = this.getSDO();
        String id = sdo.getId();
        this.putAttribute("isDetailPage","true");
        WorkInstructionApply workInstructionApply =(id==null||"".equals(id))?null: workInstructionApplyApplication.getWorkInstructionApplyById(id);
        return forward("workInstructionApply",workInstructionApply);
    }

    public String deleteWorkInstructionApply(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        workInstructionApplyApplication.deleteWorkInstructionByIds(ids);
        return success();
    }
}

