package com.huigou.topsun.product.domain;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.persistence.*;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.huigou.topsun.common.NumberToStringSerializer;
import lombok.Data;

/**
 * 生产工厂
 * @TableName factory
 */
@Table(name="factory")
@Entity
@JsonInclude(JsonInclude.Include.ALWAYS)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Factory implements Serializable {
    /**
     * 工厂ID
     */
    @Id
    @Column(name = "factory_id")
    @JsonSerialize(using = NumberToStringSerializer.class)
    private BigDecimal factoryId;

    /**
     * 工厂名称
     */
    @Column(name = "factory_name")
    private String factoryName;

    /**
     * 工厂编码
     */
    @Column(name = "factory_code")
    private String factoryCode;

    public BigDecimal getFactoryId() {
        return factoryId;
    }

    public void setFactoryId(String factoryId) {
        this.factoryId = (factoryId != null) ? new BigDecimal(factoryId) : null;
    }

    public String getFactoryName() {
        return factoryName;
    }

    public void setFactoryName(String factoryName) {
        this.factoryName = factoryName;
    }

    public String getFactoryCode() {
        return factoryCode;
    }

    public void setFactoryCode(String factoryCode) {
        this.factoryCode = factoryCode;
    }
}