package com.huigou.topsun.common;

import com.huigou.context.MessageSourceContext;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Tech审批流程状态定义：TechBillStatus
 * APPLYING(0, "申请"),
 * APPROVING(1, "审批中"),
 * SUSPENDED(2, "已挂起"),
 * COMPLETED(3, "已完成"),
 * ARCHIVED(4, "已归档"),
 * ABORTED(5, "已中止");
 */
public enum BillStatus {
    APPLYING(0, "申请", 1, "tech.enum.TechBillStatus.applying"),
    APPROVING(1, "审批中", 1, "tech.enum.TechBillStatus.approving"),
    SUSPENDED(2, "已挂起", 0, "tech.enum.TechBillStatus.suspended"),
    COMPLETED(3, "已完成", 1, "tech.enum.TechBillStatus.completed"),
    ARCHIVED(4, "已归档", 0, "tech.enum.TechBillStatus.archived"),
    ABORTED(5, "已中止", 1, "tech.enum.TechBillStatus.aborted");

    private int id;

    private String displayName;

    private int isValid;

    private String i18n;

    private BillStatus(int id, String displayName, int isValid, String i18n) {
        this.id = id;
        this.displayName = displayName;
        this.isValid = isValid;
        this.i18n = i18n;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public int getIsValid() {
        return isValid;
    }

    public void setIsValid(int isValid) {
        this.isValid = isValid;
    }

    public String getI18nName() {
        return MessageSourceContext.getMessage(i18n);
    }

    public String getI18n() {
        return i18n;
    }

    public void setI18n(String i18n) {
        this.i18n = i18n;
    }

    public static Map<String, String> getMap() {
        Map<String, String> map = new LinkedHashMap<String, String>(BillStatus.values().length);
        for (BillStatus c : BillStatus.values()) {
            map.put(String.valueOf(c.getId()), MessageSourceContext.getMessage(c.getI18n()));
        }
        return map;
    }

    public static Map<String, String> getZhMap() {
        Map<String, String> map = new LinkedHashMap<String, String>(BillStatus.values().length);
        for (BillStatus c : BillStatus.values()) {
            map.put(String.valueOf(c.getId()), c.getDisplayName());
        }
        return map;
    }

    /**
     * 获取有效的流程状态
     * 
     * @return
     */
    public static Map<String, String> getValidMap() {
        Map<String, String> map = new LinkedHashMap<String, String>(BillStatus.values().length);
        for (BillStatus c : BillStatus.values()) {
            String statusId = String.valueOf(c.getId());
            if (c.getIsValid() == YesOrNo.YES.getId()) {
                // map.put(statusId, MessageSourceContext.getMessage(c.getI18n()));
                map.put(statusId, c.getDisplayName());
            }
        }
        return map;
    }

    public static BillStatus fromId(int id) {
        for (BillStatus c : BillStatus.values()) {
            if (c.getId() == id) {
                return c;
            }
        }

        // throw new RuntimeException(String.format("无效流程状态“%s”！", id));
        return null;
    }
}
