package com.huigou.topsun.sap.wasteSale.domain;

import com.huigou.data.domain.model.AbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/13/19:06
 * @Description:
 */
@Data
@Entity
@Table(name = "sap_waste_sale_item")
public class WasteSaleItem extends AbstractEntity {

    @Column(name = "waste_sale_id")
    private String wasteSaleId;

    /**
     * 序号
     */
    @Column(name = "sequence")
    private Integer sequence;

    /**
     * 回收品类
     */
    @Column(name = "waste_type")
    private String wasteType;

    /**
     * 数量
     */
    @Column(name = "quantity")
    private BigDecimal quantity;

    /**
     * 单价
     */
    @Column(name = "price")
    private BigDecimal price;

    /**
     * 计量单位
     */
    @Column(name = "unit")
    private String unit;

    @Column(name = "unit_name")
    private String unitName;

    /**
     * 总价
     */
    @Column(name = "amount")
    private BigDecimal amount;

    /**
     * 车辆皮重
     */
    @Column(name = "car_weight")
    private BigDecimal carWeight;

    /**
     * 毛重
     */
    @Column(name = "gross_weight")
    private BigDecimal grossWeight;

    /**
     * 扣减重量
     */
    @Column(name = "deduct_weight")
    private BigDecimal deductWeight;

    /**
     * 净重
     */
    @Column(name = "net_weight")
    private BigDecimal netWeight;

    /**
     * 备注
     */
    @Column(name = "remark")
    private String remark;

    /**
     * 出售物品
     */
    @Column(name = "sale_goods")
    private String saleGoods;

    /**
     * 税率
     */
    @Column(name = "kbetr")
    private BigDecimal kbetr;
}
