package com.huigou.topsun.sap.transfers.application;

import com.huigou.topsun.sap.permit.domain.SapPermit;
import com.huigou.topsun.sap.permit.domain.query.SapPermitQueryRequest;
import com.huigou.topsun.sap.purchase.domain.SapPurchaseItem;
import com.huigou.topsun.sap.purchaseApproval.domain.SapPurchaseApproval;
import com.huigou.topsun.sap.purchaseApproval.domain.SapPurchaseApprovalItem;
import com.huigou.topsun.sap.transfers.domain.SapStockTransfers;
import com.huigou.topsun.sap.transfers.domain.query.SapStockTransfersQueryRequest;

import java.util.List;
import java.util.Map;

/**
 * @Auther:LXH
 * @Date: 2024/03/27/19:35
 * @Description:
 */
public interface SapStockTransfersApplication {
    public static final String QUERY_XML_FILE_PATH = "config/topsun/sap/transfers/sapStockTransfers.xml";

    String PROCESS_DEFINITION_KEY = "sapStockTransfersProc";

    Map<String, Object> getStockTransfersList(SapStockTransfersQueryRequest stockTransfersVo);

    SapStockTransfers getStockTransfersById(String id);

    void deleteByIds(List<String> ids);

    /**
     * 创建存货转移单
     * @param sapPurchaseApprovalItems
     */
    void createSapStockTransfersFromPurchaseApproval(SapPurchaseApproval sapPurchaseApproval,List<SapPurchaseApprovalItem> sapPurchaseApprovalItems);

   // List<TmpPermitData>  importExcelData(String batchNumber) ;
}
