package com.huigou.topsun.sap.qualityInfoRecord.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.sap.qualityInfoRecord.application.SapQualityInfoRecordApplication;
import com.huigou.topsun.sap.qualityInfoRecord.application.SapQualityInfoRecordItemApplication;
import com.huigou.topsun.sap.qualityInfoRecord.domain.SapQualityInfoRecord;
import com.huigou.topsun.sap.qualityInfoRecord.domain.SapQualityInfoRecordItem;
import com.huigou.topsun.sap.qualityInfoRecord.domain.query.SapQualityInfoRecordQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import oracle.sql.NUMBER;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/02/28/15:40
 * @Description:
 */
@Controller
@ControllerMapping("/sapQualityInfoRecord")
public class SapQualityInfoRecordController extends CommonController {
    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/qualityInfoRecord/";
    }

    @Resource
    private SapQualityInfoRecordApplication sapQualityInfoRecordApplication;
    @Resource
    private SapQualityInfoRecordItemApplication sapQualityInfoRecordItemApplication;

    public String forwardSapQualityInfoRecordList(){
        return forward("qualityInfoRecordList");
    }

    public String slicedSapQualityInfoRecordList(){
        SDO sdo = this.getSDO();
        SapQualityInfoRecordQueryRequest queryRequest = sdo.toQueryRequest(SapQualityInfoRecordQueryRequest.class);
        Map<String, Object> map = sapQualityInfoRecordApplication.slicedSapQualityInfoRecordList(queryRequest);
        return toResult(map);
    }

    public String forwardSapQualityInfoRecordDetail(){
        this.putAttribute("processDefinitionKey", SapQualityInfoRecordApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        SapQualityInfoRecord sapQualityInfoRecord = new SapQualityInfoRecord();
        sapQualityInfoRecord.setStatusId(BizBillStatus.APPLYING.getId());
        /**
         * 设置jsp页面初始化填充数据，如果不设置， 那么在jsp页面上填写完表单之后立即提交申请TaskDescription获取不到时间和相关人员信息
         */
        Operator operator = getOperator();
        sapQualityInfoRecord.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        return forward("qualityInfoRecordDetail", sapQualityInfoRecord);
    }

    public String showSapQualityInfoRecordDetail(){
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        SapQualityInfoRecord sapQualityInfoRecord = sapQualityInfoRecordApplication.loadSapQualityInfoRecord(id);
        List<SapQualityInfoRecordItem> list=sapQualityInfoRecordItemApplication.findBySapQualityInfoRecordId(id);
        return forward("qualityInfoRecordDetail", list.get(0));
    }

    public String copyQualityInfoRecord(){
        this.putAttribute("processDefinitionKey", SapQualityInfoRecordApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        SDO sdo = this.getSDO();
        String id = sdo.getId();
        SapQualityInfoRecord sapQualityInfoRecord = sapQualityInfoRecordApplication.loadSapQualityInfoRecord(id);
        sapQualityInfoRecord.setId(null);
        sapQualityInfoRecord.setZqinfno(null);
        sapQualityInfoRecord.setType(null);
        sapQualityInfoRecord.setMessage(null);
        sapQualityInfoRecord.setZqavfn1(null);
        sapQualityInfoRecord.setZvfnc1(null);
        sapQualityInfoRecord.setZqavfn2(null);
        sapQualityInfoRecord.setZvfnc2(null);
        sapQualityInfoRecord.setZqavfn3(null);
        sapQualityInfoRecord.setZvfnc3(null);
        sapQualityInfoRecord.setZqavfn4(null);
        sapQualityInfoRecord.setZvfnc4(null);
        sapQualityInfoRecord.setStatusId(BizBillStatus.APPLYING.getId());
        Operator operator = getOperator();
        sapQualityInfoRecord.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        return forward("qualityInfoRecordDetail", sapQualityInfoRecord);
    }

}
