package com.huigou.topsun.sap.productScrapApply.controller;

import com.huigou.context.Operator;
import com.huigou.context.OrgUnit;
import com.huigou.topsun.common.BillStatus;
import com.huigou.topsun.sap.productScrapApply.application.ProductScrapApplyApplication;
import com.huigou.topsun.sap.productScrapApply.application.ProductScrapApplyItemApplication;
import com.huigou.topsun.sap.productScrapApply.domain.ProductScrapApply;
import com.huigou.topsun.sap.productScrapApply.domain.query.ProductScrapApplyQueryRequest;
import com.huigou.topsun.sap.productScrapApply.vo.ProductScrapApplyVo;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.annotation.SkipAuth;
import com.huigou.uasp.bmp.common.BizBillStatus;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.JSONUtil;
import com.huigou.util.SDO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/07/09/14:47
 * @Description:
 */
@Controller
@ControllerMapping("/productScrapApply")
public class ProductScrapApplyController extends CommonController {
    private final static Logger LOG = LoggerFactory.getLogger(ProductScrapApplyController.class);
    @Autowired
    private ProductScrapApplyApplication productScrapApplyApplication;
    @Autowired
    private ProductScrapApplyItemApplication productScrapApplyItemApplication;
    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/productScrapApply/";
    }

    @SkipAuth
    @RequestMapping( value = "/getProductScrapApply")
    @ResponseBody
    public HashMap<String, Object> getProductScrapApply(@RequestBody List<ProductScrapApplyVo> productScrapApplyVoListVo){
        //SDO sdo = this.getSDO();
        HashMap<String, Object> messageMap = new HashMap<>();
        messageMap.put("CODE","S");
        messageMap.put("MSG","成功");
        messageMap.put("DATA","");
        LOG.info("物品报废申请与过账平台数据=={}", JSONUtil.toString(productScrapApplyVoListVo));
        String billCode = "";
        try {
            if (CollectionUtils.isEmpty(productScrapApplyVoListVo)){
                messageMap.put("CODE","E");
                messageMap.put("MSG","未接收到数据，请检查");
                messageMap.put("DATA","");
            }else {
                billCode = this.productScrapApplyApplication.saveProductScrapApplyVo(productScrapApplyVoListVo);
            }
        }catch (RuntimeException e){
            messageMap.put("CODE","E");
            messageMap.put("MSG",e.getMessage());
            messageMap.put("DATA","");
        }
        messageMap.put("ZBPMID",billCode);
        return messageMap;
    }

    public String forwardProductScrapApplyList(){
        this.putAttribute("statusKindsList", BillStatus.getValidMap());
        return forward("productScrapApplyList");
    }

    public String slicedProductScrapApplyList(){
        SDO sdo = this.getSDO();
        ProductScrapApplyQueryRequest queryRequest = sdo.toQueryRequest(ProductScrapApplyQueryRequest.class);
        Map<String, Object> map = productScrapApplyApplication.slicedProductScrapApplyList(queryRequest);
        return toResult(map);
    }

    public String forwardProductScrapApplyDetail(){
        this.putAttribute("processDefinitionKey", ProductScrapApplyApplication.PROCESS_DEFINITION_KEY);
        // 新增的时候procUnitId一定要设置成Apply，不然jsp页面的所有表单元素是readonly状态
        this.putAttribute("procUnitId", "Apply");
        ProductScrapApply sapPurchase = new ProductScrapApply();
        sapPurchase.setStatusId(BizBillStatus.APPLYING.getId());
        /**
         * 设置jsp页面初始化填充数据，如果不设置， 那么在jsp页面上填写完表单之后立即提交申请TaskDescription获取不到时间和相关人员信息
         */
        Operator operator = getOperator();
        sapPurchase.setDefaultValues(new OrgUnit(operator.getFullId(), operator.getFullName()));
        return forward("productScrapApplyDetail",sapPurchase);
    }

    public String showProductScrapApplyDetail(){
        SDO sdo = this.getSDO();
        String id = sdo.getBizId();
        ProductScrapApply productScrapApply = productScrapApplyApplication.loadProductScrapApply(id);
        return forward("productScrapApplyDetail",productScrapApply);
    }

    public String queryProductScrapApplyItems(){
        SDO sdo = this.getSDO();
        ProductScrapApplyQueryRequest queryRequest = sdo.toQueryRequest(ProductScrapApplyQueryRequest.class);
        Map<String, Object> map = productScrapApplyItemApplication.queryProductScrapApplyItems(queryRequest);
        return toResult(map);
    }

    public String deleteProductScrapApplyItem(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        productScrapApplyItemApplication.deleteByIds(ids);
        return success();
    }
}
