package com.huigou.topsun.sap.produceSupplierReview.domain;

import com.huigou.data.domain.model.AbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * @Auther: xin.lu
 * @Date: 2024/06/03/15:44
 * @Description: 新供应商评审表评估项目
 */
@Entity
@Data
@Table(name = "sap_new_supplier_review_item")
public class NewSupplierReviewItem extends AbstractEntity {
    /**
     * 新供应商评审表id
     */
    @Column(name = "new_supplier_review_id")
    private String newSupplierReviewId;

    /**
     * 评估项目所属类型
     * 1.品质管理体系：2.文件控制：3.供应商品质控制：4.产品质量控制：5.不合格品控制：7.量测仪器管制：8.产品包装与防护：
     * 'quality','file','supplier','product','unqualified','mark','measure','package',
     *
     * 1.生产设备及工治具评估：2.工程变更管制：3.产能评估：
     * 'device','change','produce','
     *
     * 1.价格评估：2.交期评估：3.付款周期评估：
     * price','giveDate','payDate'
     */
    @Column(name = "item_type")
    private String itemType;

    /**
     * 评估项目
     */
    @Column(name = "review_item")
    private String reviewItem;

    /**
     * 自评分
     */
    @Column(name = "self_rate")
    private String selfRate;

    /**
     * SG评分
     */
    @Column(name = "sg_rate")
    private String sgRate;

    /**
     * 不合格现象描述
     */
    @Column(name = "no_qualified_des")
    private String noQualifiedDes;
}
