package com.huigou.topsun.sap.nonProducePick.domain;

import com.huigou.data.domain.model.AbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/13/9:37
 * @Description:
 */
@Data
@Entity
@Table(name = "sap_non_produce_pick_item")
public class NonProducePickItem extends AbstractEntity {

    /**
     * SAP非生产性领料申请与发料过账id
     */
    @Column(name = "non_produce_pick_id")
    private String nonProducePickId;

    /**
     *序号
     */
    @Column(name = "RSPOS")
    private String rspos;
    /**
     * 物料组
     */
    @Column(name = "MATKL")
    private String matkl;

    /**
     * 物料组描述
     */
    @Column(name = "WGBEZ")
    private String wgbez;

    /**
     *物料
     */
    @Column(name = "MATNR")
    private String matnr;

    /**
     *SAP物料名称
     */
    @Column(name = "MAKTX")
    private String maktx;

    /**
     *库存地点
     */
    @Column(name = "LGORT")
    private String lgort;

    @Column(name = "LGOBE")
    private String lgobe;

    /**
     *数量
     */
    @Column(name = "ERFMG")
    private BigDecimal erfmg;

    /**
     *单位
     */
    @Column(name = "MEINS")
    private String meins;

    @Column(name = "MSEHL")
    private String msehl;

    /**
     *收货方
     */
    @Column(name = "WEMPF")
    private String wempf;


    /**
     *用途
     */
    @Column(name = "used")
    private String used;


    /**
     *备注
     */
    @Column(name = "remark")
    private String remark;

    /**
     *退料数量
     */
    @Column(name = "back_num")
    private BigDecimal backNum;

    /**
     *退料原因
     */
    @Column(name = "back_reason")
    private String backReason;

    /**
     *冲销凭证号
     */
    @Column(name = "charge_off_message")
    private String chargeOffMessage;

    /**
     *退料时间
     */
    @Column(name = "back_date")
    private Date backDate;

    /**
     * 实际退料数量
     */
    @Column(name = "zerfmg")
    private BigDecimal zerfmg;

    /**
     * 完结状态 'Y'，'N
     */
    @Column(name = "checked_box")
    private String checkedBox;

    /**
     * 物料要求描述
     */
    @Column(name = "matxt")
    private String matxt;

}
