package com.huigou.topsun.sap.nonProducePick.controller;

import com.huigou.topsun.sap.nonProducePick.application.NonProducePickItemApplication;
import com.huigou.topsun.sap.nonProducePick.domain.NonProducePickItem;
import com.huigou.topsun.sap.nonProducePick.domain.query.NonProducePickQueryRequest;
import com.huigou.uasp.annotation.ControllerMapping;
import com.huigou.uasp.client.CommonController;
import com.huigou.util.SDO;
import org.springframework.stereotype.Controller;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/13/10:46
 * @Description:
 */
@Controller
@ControllerMapping("/nonProducePickItem")
public class NonProducePickItemController extends CommonController {
    @Override
    protected String getPagePath() {
        return "/biz/topsun/sap/nonProducePick/";
    }
    @Resource
    private NonProducePickItemApplication nonProducePickItemApplication;

    public String queryNonProducePickItems(){
        SDO sdo = this.getSDO();
        NonProducePickQueryRequest queryRequest = sdo.toQueryRequest(NonProducePickQueryRequest.class);
        Map<String, Object> map = nonProducePickItemApplication.queryNonProducePickItems(queryRequest);
        return toResult(map);
    }

    public String deleteNonProducePickItem(){
        SDO sdo = this.getSDO();
        List<String> ids = sdo.getIds();
        String nonProducePickId = sdo.getString("nonProducePickId");
        nonProducePickItemApplication.deleteByIds(ids,nonProducePickId);
        return success();
    }



    public String showBack(){
        SDO sdo = this.getSDO();
        String id = sdo.getId();
        NonProducePickItem item = nonProducePickItemApplication.findById(id);
        return forward("showBack",item);
    }

    public String saveNonProducePickItem(){
        SDO sdo = this.getSDO();
        NonProducePickItem nonProducePickItem = sdo.toObject(NonProducePickItem.class);
        nonProducePickItemApplication.updateNonProducePickItem(nonProducePickItem);
        return success();
    }
}
