package com.huigou.topsun.sap.inventoryRecord.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.huigou.data.domain.model.AbstractEntity;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * WM库存盘点
 */
@Entity
@Data
@Table(name = "sap_inventory_record_item_wm")
public class InventoryRecordItemWm extends AbstractEntity {

    @Column(name = "inventory_record_id")
    private String inventoryRecordId;

    // 仓库号
    @Column(name = "lgnum")
    private String lgnum;

    @Column(name = "lnumt")
    private String lnumt;

    // 盘点记录号
    @Column(name = "ivnum")
    private String ivnum;

    // 重新盘点版本
    @Column(name = "nvers")
    private String nvers;
    
    // 项目号
    @Column(name = "ivpos")
    private String ivpos;
    
    // 仓位
    @Column(name = "lgpla")
    private String lgpla;

    // 物料
    @Column(name = "matnr")
    private String matnr;

    // 物料描述
    @Column(name = "MAKTX")
    private String maktx;

    // 批次
    @Column(name = "charg")
    private String charg;

    // 工厂
    @Column(name = "werks")
    private String werks;

    //工厂名称
    @Column(name = "name1")
    private String name1;

    // 存储地点
    @Column(name = "lgort")
    private String lgort;

    //存储地点名称
    @Column(name = "lgobe")
    private String lgobe;
    
    // 库存类别
    @Column(name = "bestq")
    private String bestq;
    
    // 特殊库存标识
    @Column(name = "sobkz")
    private String sobkz;

    // 特殊库存编号
    @Column(name = "sonum")
    private String sonum;
    
    // 盘点数量
    @Column(name = "menga")
    private BigDecimal menga;
    
    // 盘点数量单位
    @Column(name = "altme")
    private String altme;

    //单位描述
    @Column(name = "MSEHL")
    private String msehl;
    
    // 账面数量
    @Column(name = "gesme")
    private BigDecimal gesme;
    
    // 差异
    @Column(name = "abwei")
    private String abwei;
    
    // 价值差额
    @Column(name = "dwert")
    private BigDecimal dwert;
    
    // 货币
    @Column(name = "waers")
    private String waers;

    //货币描述
    @Column(name = "ktext")
    private String ktext;
    
    // 盘点完成日期
    @Column(name = "idatu")
    private String idatu;
}