package com.huigou.topsun.sap.fixedAssets.application.impl;

import com.huigou.data.query.model.QueryDescriptor;
import com.huigou.data.query.model.QueryModel;
import com.huigou.topsun.sap.fixedAssets.application.SapFixedAssetsMoveItemApplication;
import com.huigou.topsun.sap.fixedAssets.domain.SapFixedAssetsMoveItem;
import com.huigou.topsun.sap.fixedAssets.domain.query.SapFixedAssetsMoveQueryRequest;
import com.huigou.topsun.sap.fixedAssets.repository.SapFixedAssetsMoveItemRepository;
import com.huigou.uasp.bmp.common.application.BaseApplication;
import com.huigou.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Auther: xin.lu
 * @Date: 2024/03/02/16:36
 * @Description:
 */
@Service("sapFixedAssetsMoveItemApplication")
public class SapFixedAssetsMoveItemApplicationImpl extends BaseApplication implements SapFixedAssetsMoveItemApplication {
    @Autowired
    private SapFixedAssetsMoveItemRepository sapFixedAssetsMoveItemRepository;
    @Override
    public void saveSapFixedAssetsMoveItemItems(String sapFixedAssetsMoveId, List<SapFixedAssetsMoveItem> items) {
        for (SapFixedAssetsMoveItem item : items) {
            item.setSapFixedAssetsMoveId(sapFixedAssetsMoveId);
            sapFixedAssetsMoveItemRepository.save(item);
        }
    }

    @Override
    public Map<String, Object> querySapFixedAssetsMoveItems(SapFixedAssetsMoveQueryRequest queryRequest) {
        Map<String, Object> map = new HashMap<>();
        if (StringUtil.isNotBlank(queryRequest.getSapFixedAssetsMoveId())){
            QueryDescriptor queryDescriptor = this.sqlExecutorDao.getQuery(QUERY_XML_FILE_PATH, "sapFixedAssetsMoveItems");
            QueryModel queryModel = this.sqlExecutorDao.getQueryModel(queryDescriptor, queryRequest);
            map = this.sqlExecutorDao.executeSlicedQuery(queryModel);
        }
        return map;
    }

    @Override
    public void deleteByIds(List<String> ids) {
        ids.forEach(id->{
            sapFixedAssetsMoveItemRepository.delete(id);
        });
    }

    @Override
    public List<SapFixedAssetsMoveItem> findBySapFixedAssetsMoveId(String sapFixedAssetsMoveId) {
        return sapFixedAssetsMoveItemRepository.findBySapFixedAssetsMoveId(sapFixedAssetsMoveId);
    }
}
