package com.huigou.topsun.sap.finaCustomer.domain;

import lombok.Data;
import org.hibernate.annotations.GenericGenerator;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 
 * @TableName sap_fina_customer_pay
 */
@Table(name="sap_fina_customer_pay")
@Data
@Entity
public class FinaCustomerPay implements Serializable {


    @Id
    @GeneratedValue(
            generator = "system-uuid"
    )
    @GenericGenerator(
            name = "system-uuid",
            strategy = "guid"
    )

    private String id;

    /**
     * 主表id
     */
    @Column(name = "s_id")
    private String sId;

    /**
     * 公司代码
     */
    @Column(name = "bukrs")
    private String bukrs;

    /**
     * 总帐中的统驭科目
     */
    @Column(name = "akont_customer")
    private String akontCustomer;


    /**
     * 根据分配号排序代码
     */
    @Column(name = "zuawa")
    private String zuawa;

    /**
     * 根据分配号排序代码
     */
    @Column(name = "zuawa_name")
    private String zuawaName;

    /**
     * 付款条件代码
     */
    @Column(name = "zterm")
    private String zterm;

    /**
     * 付款条件描述
     */
    @Column(name = "zterm_name")
    private String ztermName;

    /**
     * 对公司代码过帐冻结
     */
    @Column(name = "sperr_b")
    private String sperrB;

    /**
     * 考虑的付款方式清单
     */
    @Column(name = "zwels")
    private String zwels;

    @Column(name = "sequence")
    private int sequence;

    private static final long serialVersionUID = 1L;
}